/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class ArtifactRepositoriesPluginResolver
implements PluginResolver {
    public static final String PLUGIN_MARKER_SUFFIX = ".gradle.plugin";
    @VisibleForTesting
    static final String SOURCE_NAME = "Plugin Repositories";
    private final DependencyResolutionServices resolution;
    private final VersionSelectorScheme versionSelectorScheme;

    public static ArtifactRepositoriesPluginResolver createWithDefaults(DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme) {
        RepositoryHandler repositories = dependencyResolutionServices.getResolveRepositoryHandler();
        if (repositories.isEmpty()) {
            repositories.gradlePluginPortal();
        }
        return new ArtifactRepositoriesPluginResolver(dependencyResolutionServices, versionSelectorScheme);
    }

    public ArtifactRepositoriesPluginResolver(DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme) {
        this.resolution = dependencyResolutionServices;
        this.versionSelectorScheme = versionSelectorScheme;
        JavaEcosystemSupport.configureSchema(dependencyResolutionServices.getAttributesSchema(), dependencyResolutionServices.getObjectFactory());
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        ModuleDependency markerDependency = this.getMarkerDependency(pluginRequest);
        String markerVersion = markerDependency.getVersion();
        if (Strings.isNullOrEmpty(markerVersion)) {
            result.notFound(SOURCE_NAME, "plugin dependency must include a version number for this source");
            return;
        }
        if (this.versionSelectorScheme.parseSelector(markerVersion).isDynamic()) {
            result.notFound(SOURCE_NAME, "dynamic plugin versions are not supported");
            return;
        }
        if (this.exists(markerDependency)) {
            this.handleFound(result, pluginRequest, markerDependency);
        } else {
            this.handleNotFound(result, "could not resolve plugin artifact '" + this.getNotation(markerDependency) + "'");
        }
    }

    private void handleFound(PluginResolutionResult result, final PluginRequestInternal pluginRequest, final Dependency markerDependency) {
        result.found(SOURCE_NAME, new PluginResolution(){

            @Override
            public PluginId getPluginId() {
                return pluginRequest.getId();
            }

            @Override
            public void execute(@Nonnull PluginResolveContext context) {
                context.addLegacy(pluginRequest.getId(), markerDependency);
            }
        });
    }

    private void handleNotFound(PluginResolutionResult result, String message2) {
        StringBuilder detail = new StringBuilder("Searched in the following repositories:\n");
        Iterator it = this.resolution.getResolveRepositoryHandler().iterator();
        while (it.hasNext()) {
            detail.append("  ").append(((ArtifactRepositoryInternal)it.next()).getDisplayName());
            if (!it.hasNext()) continue;
            detail.append("\n");
        }
        result.notFound(SOURCE_NAME, message2, detail.toString());
    }

    private boolean exists(ModuleDependency dependency) {
        ConfigurationContainer configurations = this.resolution.getConfigurationContainer();
        Configuration configuration = configurations.detachedConfiguration(dependency);
        configuration.setTransitive(false);
        return !configuration.getResolvedConfiguration().hasError();
    }

    private ModuleDependency getMarkerDependency(PluginRequestInternal pluginRequest) {
        ModuleVersionSelector selector = pluginRequest.getModule();
        if (selector == null) {
            String id = pluginRequest.getId().getId();
            return new DefaultExternalModuleDependency(id, id + PLUGIN_MARKER_SUFFIX, pluginRequest.getVersion());
        }
        return new DefaultExternalModuleDependency(selector.getGroup(), selector.getName(), selector.getVersion());
    }

    private String getNotation(Dependency dependency) {
        return Joiner.on(':').join(dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }
}

