/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;

public abstract class AbstractLibrary
extends AbstractClasspathEntry {
    private static final String ATTRIBUTE_JAVADOC_LOCATION = "javadoc_location";
    private FileReference sourcePath;
    private FileReference javadocPath;
    private FileReference library;
    private ModuleVersionIdentifier moduleVersion;

    public AbstractLibrary(Node node, FileReferenceFactory fileReferenceFactory) {
        super(node);
        String javadocLocation = (String)this.getEntryAttributes().get(ATTRIBUTE_JAVADOC_LOCATION);
        this.javadocPath = fileReferenceFactory.fromJarURI(javadocLocation);
    }

    public AbstractLibrary(FileReference library) {
        super(library.getPath());
        this.library = library;
    }

    public FileReference getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(FileReference sourcePath) {
        this.sourcePath = sourcePath;
    }

    public FileReference getJavadocPath() {
        return this.javadocPath;
    }

    public void setJavadocPath(FileReference path) {
        this.javadocPath = path;
        if (path != null) {
            String location = path.getJarURL();
            this.getEntryAttributes().put(ATTRIBUTE_JAVADOC_LOCATION, location);
        } else {
            this.getEntryAttributes().remove(ATTRIBUTE_JAVADOC_LOCATION);
        }
    }

    public FileReference getLibrary() {
        return this.library;
    }

    public void setLibrary(FileReference library) {
        this.library = library;
        this.setPath(library.getPath());
    }

    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(@Nullable ModuleVersionIdentifier moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    @Override
    public void appendNode(Node node) {
        LinkedHashMap<String, String> attributes = Maps.newLinkedHashMap();
        attributes.put("sourcepath", this.sourcePath == null ? null : this.sourcePath.getPath());
        this.addClasspathEntry(node, attributes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractLibrary that = (AbstractLibrary)o;
        return Objects.equal(this.isExported(), that.isExported()) && Objects.equal(this.getAccessRules(), that.getAccessRules()) && Objects.equal(this.getJavadocPath(), that.getJavadocPath()) && Objects.equal(this.getNativeLibraryLocation(), that.getNativeLibraryLocation()) && Objects.equal(this.getPath(), that.getPath()) && Objects.equal(this.getSourcePath(), that.getSourcePath());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getPath(), this.getNativeLibraryLocation(), this.isExported(), this.getAccessRules(), this.getSourcePath(), this.getJavadocPath());
    }

    @Override
    public String toString() {
        return "{path='" + this.getPath() + "', nativeLibraryLocation='" + this.getNativeLibraryLocation() + "', exported=" + this.isExported() + ", accessRules=" + this.getAccessRules() + ", sourcePath='" + this.sourcePath + "', javadocPath='" + this.javadocPath + "', id='" + this.moduleVersion + "'}";
    }
}

