/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import java.util.LinkedHashMap;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class Facet {
    private FacetType type;
    private String name;
    private String version;

    public Facet() {
        this.type = FacetType.installed;
    }

    public Facet(Node node) {
        this(FacetType.valueOf((String)node.name()), (String)node.attribute((Object)"facet"), (String)node.attribute((Object)"version"));
    }

    public Facet(String name, String version) {
        this(FacetType.installed, name, version);
    }

    public Facet(FacetType type, String name, String version) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(name);
        if (type == FacetType.installed) {
            Preconditions.checkNotNull(version);
        } else {
            Preconditions.checkArgument(version == null);
        }
        this.type = type;
        this.name = name;
        this.version = version;
    }

    public FacetType getType() {
        return this.type;
    }

    public void setType(FacetType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void appendNode(Node node) {
        LinkedHashMap<String, String> attributes = Maps.newLinkedHashMap();
        attributes.put("facet", this.name);
        if (this.type == FacetType.installed) {
            attributes.put("version", this.version);
        }
        node.appendNode((Object)this.type.name(), attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Facet facet = (Facet)o;
        return this.type == facet.type && Objects.equal(this.name, facet.name) && Objects.equal(this.version, facet.version);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.name, this.version});
    }

    public String toString() {
        return "Facet{type='" + (Object)((Object)this.type) + "', name='" + this.name + "', version='" + this.version + "'}";
    }

    public static enum FacetType {
        installed,
        fixed;

    }
}

