/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class Link {
    private String name;
    private String type;
    private String location;
    private String locationUri;

    public Link(String name, String type, String location, String locationUri) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(type));
        Preconditions.checkArgument(Strings.isNullOrEmpty(location) || Strings.isNullOrEmpty(locationUri));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(location) || !Strings.isNullOrEmpty(locationUri));
        this.name = name;
        this.type = type;
        this.location = PathUtil.normalizePath(Strings.emptyToNull(location));
        this.locationUri = Strings.emptyToNull(locationUri);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equal(this.name, link.name) && Objects.equal(this.type, link.type) && Objects.equal(this.location, link.location) && Objects.equal(this.locationUri, link.locationUri);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.locationUri != null ? this.locationUri.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Link{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", location='" + this.location + '\'' + ", locationUri='" + this.locationUri + '\'' + '}';
    }
}

