/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import java.util.LinkedHashMap;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class Output
implements ClasspathEntry {
    private String path;

    public Output(Node node) {
        this((String)node.attribute((Object)"path"));
    }

    public Output(String path) {
        Preconditions.checkNotNull(path);
        this.path = PathUtil.normalizePath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getKind() {
        return "output";
    }

    @Override
    public void appendNode(Node node) {
        LinkedHashMap<String, String> attributes = Maps.newLinkedHashMap();
        attributes.put("kind", this.getKind());
        attributes.put("path", this.path);
        node.appendNode((Object)"classpathentry", attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equal(this.path, output.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    public String toString() {
        return "Output{path='" + this.path + "'}";
    }
}

