/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import groovy.util.NodeList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.eclipse.model.Facet;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class WtpFacet
extends XmlPersistableConfigurationObject {
    private List<Facet> facets = Lists.newArrayList();

    public WtpFacet(XmlTransformer xmlTransformer) {
        super(xmlTransformer);
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    @Override
    protected void load(Node xml) {
        NodeList fixed = (NodeList)xml.get("fixed");
        NodeList installed = (NodeList)xml.get("installed");
        for (Object n : fixed) {
            this.facets.add(new Facet((Node)n));
        }
        for (Object n : installed) {
            this.facets.add(new Facet((Node)n));
        }
    }

    @Override
    protected void store(Node xml) {
        this.removeConfigurableDataFromXml();
        for (Facet facet : this.facets) {
            facet.appendNode(xml);
        }
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultWtpFacet.xml";
    }

    public void configure(List<Facet> facets) {
        this.facets.addAll(facets);
        this.removeDuplicates();
    }

    private void removeDuplicates() {
        this.facets = Lists.newArrayList(Sets.newLinkedHashSet(this.facets));
    }

    private void removeConfigurableDataFromXml() {
        Node xml = this.getXml();
        NodeList fixed = (NodeList)xml.get("fixed");
        NodeList installed = (NodeList)xml.get("installed");
        for (Object n : fixed) {
            xml.remove((Node)n);
        }
        for (Object n : installed) {
            xml.remove((Node)n);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WtpFacet wtpFacet = (WtpFacet)o;
        return Objects.equal(this.facets, wtpFacet.facets);
    }

    public int hashCode() {
        return Objects.hashCode(this.facets);
    }

    public String toString() {
        return "WtpFacet{facets=" + this.facets + "}";
    }
}

