/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;

public class Jdk {
    private boolean assertKeyword;
    private boolean jdk15;
    private String languageLevel;
    private String projectJdkName;

    public Jdk(String jdkName, IdeaLanguageLevel ideaLanguageLevel) {
        if (jdkName.startsWith("1.4")) {
            this.assertKeyword = true;
            this.jdk15 = false;
        } else if (jdkName.compareTo("1.5") >= 0) {
            this.assertKeyword = true;
            this.jdk15 = true;
        } else {
            this.assertKeyword = false;
        }
        this.languageLevel = ideaLanguageLevel.getLevel();
        this.projectJdkName = jdkName;
    }

    public Jdk(boolean assertKeyword, boolean jdk15, String languageLevel, String projectJdkName) {
        this.assertKeyword = assertKeyword;
        this.jdk15 = jdk15;
        this.languageLevel = languageLevel;
        this.projectJdkName = projectJdkName;
    }

    public boolean isAssertKeyword() {
        return this.assertKeyword;
    }

    public void setAssertKeyword(boolean assertKeyword) {
        this.assertKeyword = assertKeyword;
    }

    public boolean isJdk15() {
        return this.jdk15;
    }

    public void setJdk15(boolean jdk15) {
        this.jdk15 = jdk15;
    }

    public String getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(String languageLevel) {
        this.languageLevel = languageLevel;
    }

    public String getProjectJdkName() {
        return this.projectJdkName;
    }

    public void setProjectJdkName(String projectJdkName) {
        this.projectJdkName = projectJdkName;
    }

    public String toString() {
        return "Jdk{assertKeyword=" + this.assertKeyword + ", jdk15=" + this.jdk15 + ", languageLevel='" + this.languageLevel + "', projectJdkName='" + this.projectJdkName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Jdk jdk = (Jdk)o;
        if (this.assertKeyword != jdk.assertKeyword) {
            return false;
        }
        if (this.jdk15 != jdk.jdk15) {
            return false;
        }
        return Objects.equal(this.languageLevel, jdk.languageLevel) && Objects.equal(this.projectJdkName, jdk.projectJdkName);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.assertKeyword ? 1 : 0);
        result = 31 * result + (this.jdk15 ? 1 : 0);
        result = 31 * result + (this.languageLevel != null ? this.languageLevel.hashCode() : 0);
        result = 31 * result + (this.projectJdkName != null ? this.projectJdkName.hashCode() : 0);
        return result;
    }
}

