/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import groovy.util.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.JarDirectory;
import org.gradle.plugins.ide.idea.model.Path;

public class ModuleLibrary
implements Dependency {
    private Set<Path> classes;
    private Set<JarDirectory> jarDirectories;
    private Set<Path> javadoc;
    private Set<Path> sources;
    private String scope;
    private boolean exported;

    public ModuleLibrary(Collection<? extends Path> classes, Collection<? extends Path> javadoc, Collection<? extends Path> sources, Collection<JarDirectory> jarDirectories, String scope) {
        this.classes = Sets.newLinkedHashSet(classes);
        this.jarDirectories = Sets.newLinkedHashSet(jarDirectories);
        this.javadoc = Sets.newLinkedHashSet(javadoc);
        this.sources = Sets.newLinkedHashSet(sources);
        this.scope = scope;
        this.exported = false;
    }

    public Set<Path> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<Path> classes) {
        this.classes = classes;
    }

    public Set<JarDirectory> getJarDirectories() {
        return this.jarDirectories;
    }

    public void setJarDirectories(Set<JarDirectory> jarDirectories) {
        this.jarDirectories = jarDirectories;
    }

    public Set<Path> getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(Set<Path> javadoc) {
        this.javadoc = javadoc;
    }

    public Set<Path> getSources() {
        return this.sources;
    }

    public void setSources(Set<Path> sources) {
        this.sources = sources;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public void addToNode(Node parentNode) {
        LinkedHashMap<String, String> attributes;
        LinkedHashMap<String, Object> orderEntryAttributes = Maps.newLinkedHashMap();
        orderEntryAttributes.put("type", "module-library");
        orderEntryAttributes.putAll(this.getAttributeMapForScopeAndExported());
        Node libraryNode = parentNode.appendNode((Object)"orderEntry", orderEntryAttributes).appendNode((Object)"library");
        Node classesNode = libraryNode.appendNode((Object)"CLASSES");
        Node javadocNode = libraryNode.appendNode((Object)"JAVADOC");
        Node sourcesNode = libraryNode.appendNode((Object)"SOURCES");
        for (Path path : this.classes) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            classesNode.appendNode((Object)"root", attributes);
        }
        for (Path path : this.javadoc) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            javadocNode.appendNode((Object)"root", attributes);
        }
        for (Path path : this.sources) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            sourcesNode.appendNode((Object)"root", attributes);
        }
        for (JarDirectory jarDirectory : this.jarDirectories) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", jarDirectory.getPath().getUrl());
            attributes.put("recursive", String.valueOf(jarDirectory.isRecursive()));
            libraryNode.appendNode((Object)"jarDirectory", attributes);
        }
    }

    private Map<String, Object> getAttributeMapForScopeAndExported() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (this.exported) {
            builder.put("exported", "");
        }
        if (this.scope != null && !"COMPILE".equals(this.scope)) {
            builder.put("scope", this.scope);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ModuleLibrary that = (ModuleLibrary)o;
        return Objects.equal(this.classes, that.classes) && Objects.equal(this.jarDirectories, that.jarDirectories) && Objects.equal(this.javadoc, that.javadoc) && this.scopeEquals(this.scope, that.scope) && Objects.equal(this.sources, that.sources);
    }

    private boolean scopeEquals(String lhs, String rhs) {
        if ("COMPILE".equals(lhs)) {
            return Strings.isNullOrEmpty(rhs) || "COMPILE".equals(rhs);
        }
        if ("COMPILE".equals(rhs)) {
            return Strings.isNullOrEmpty(lhs) || "COMPILE".equals(lhs);
        }
        return Objects.equal(lhs, rhs);
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.jarDirectories.hashCode();
        result = 31 * result + this.javadoc.hashCode();
        result = 31 * result + this.sources.hashCode();
        result = 31 * result + this.getScopeHash();
        return result;
    }

    private int getScopeHash() {
        return !Strings.isNullOrEmpty(this.scope) && !this.scope.equals("COMPILE") ? this.scope.hashCode() : 0;
    }

    public String toString() {
        return "ModuleLibrary{classes=" + this.classes + ", jarDirectories=" + this.jarDirectories + ", javadoc=" + this.javadoc + ", sources=" + this.sources + ", scope='" + this.scope + "'}";
    }
}

