/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.plugins.ide.IdeWorkspace;
import org.gradle.process.ExecSpec;

public abstract class IdePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(IdePlugin.class);
    private TaskProvider<Task> lifecycleTask;
    private TaskProvider<Delete> cleanTask;
    protected Project project;

    public static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional<Object> gradleWrapperPath = Optional.absent();
        Project rootProject = project.getRootProject();
        String gradlewExtension = OperatingSystem.current().isWindows() ? ".bat" : "";
        File gradlewFile = rootProject.file("gradlew" + gradlewExtension);
        if (gradlewFile.exists()) {
            gradleWrapperPath = Optional.of(gradlewFile.getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or("gradle");
    }

    @Override
    public void apply(Project target) {
        this.project = target;
        String lifecycleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.getTasks().register(lifecycleTaskName);
        this.cleanTask = target.getTasks().register(this.cleanName(lifecycleTaskName), Delete.class, new Action<Delete>(){

            @Override
            public void execute(Delete task) {
                task.setGroup("IDE");
            }
        });
        this.lifecycleTask.configure(new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.setGroup("IDE");
                task.shouldRunAfter(IdePlugin.this.cleanTask);
            }
        });
        this.onApply(target);
    }

    public TaskProvider<? extends Task> getLifecycleTask() {
        return this.lifecycleTask;
    }

    public TaskProvider<? extends Task> getCleanTask() {
        return this.cleanTask;
    }

    protected String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize(taskName));
    }

    public void addWorker(Task worker) {
        this.addWorker((TaskProvider<? extends Task>)this.project.getTasks().named(worker.getName()), worker.getName());
    }

    public void addWorker(TaskProvider<? extends Task> worker, String workerName) {
        this.addWorker(worker, workerName, true);
    }

    public void addWorker(Task worker, boolean includeInClean) {
        this.addWorker((TaskProvider<? extends Task>)this.project.getTasks().named(worker.getName()), worker.getName(), includeInClean);
    }

    public void addWorker(final TaskProvider<? extends Task> worker, String workerName, boolean includeInClean) {
        this.lifecycleTask.configure(IdePlugin.dependsOn(worker));
        NamedDomainObjectProvider cleanWorker = this.project.getTasks().register(this.cleanName(workerName), Delete.class, new Action<Delete>(){

            @Override
            public void execute(Delete cleanWorker) {
                cleanWorker.delete(worker);
            }
        });
        if (includeInClean) {
            this.cleanTask.configure(IdePlugin.dependsOn((TaskProvider<? extends Task>)cleanWorker));
        }
        worker.configure((Action<? extends Task>)new Action<Task>((TaskProvider)cleanWorker){
            final /* synthetic */ TaskProvider val$cleanWorker;
            {
                this.val$cleanWorker = taskProvider;
            }

            @Override
            public void execute(Task task) {
                task.shouldRunAfter(this.val$cleanWorker);
            }
        });
    }

    protected static Action<? super Task> dependsOn(final Task taskDependency) {
        return new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.dependsOn(taskDependency);
            }
        };
    }

    protected static Action<? super Task> dependsOn(final TaskProvider<? extends Task> taskProvider) {
        return new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.dependsOn(taskProvider);
            }
        };
    }

    protected static Action<? super Task> withDescription(final String description) {
        return new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.setDescription(description);
            }
        };
    }

    protected void onApply(Project target) {
    }

    protected void addWorkspace(final IdeWorkspace workspace) {
        this.lifecycleTask.configure(new Action<Task>(){

            @Override
            public void execute(Task lifecycleTask) {
                lifecycleTask.doLast((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        LOGGER.lifecycle(String.format("Generated %s at %s", workspace.getDisplayName(), new ConsoleRenderer().asClickableFileUrl(workspace.getLocation().get().getAsFile())));
                    }
                });
            }
        });
        this.project.getTasks().register("open" + StringUtils.capitalize(this.getLifecycleTaskName()), new Action<Task>(){

            @Override
            public void execute(Task openTask) {
                openTask.dependsOn(IdePlugin.this.lifecycleTask);
                openTask.setGroup("IDE");
                openTask.setDescription("Opens the " + workspace.getDisplayName());
                openTask.doLast((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        if (OperatingSystem.current().isMacOsX()) {
                            IdePlugin.this.project.exec((Action<? super ExecSpec>)new Action<ExecSpec>(){

                                @Override
                                public void execute(ExecSpec execSpec) {
                                    execSpec.commandLine("open", workspace.getLocation().get());
                                }
                            });
                        } else {
                            try {
                                Desktop.getDesktop().open(workspace.getLocation().get().getAsFile());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    }
                });
            }
        });
    }

    protected abstract String getLifecycleTaskName();

    public boolean isRoot() {
        return this.project.getParent() == null;
    }
}

