/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.plugins.javascript.envjs.browser.BrowserEvaluator;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateSpec;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateWorker;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerHandleFactory;
import org.gradle.process.internal.worker.RequestHandler;

public class EnvJsBrowserEvaluator
implements BrowserEvaluator {
    private final RhinoWorkerHandleFactory rhinoWorkerHandleFactory;
    private final Iterable<File> rhinoClasspath;
    private final LogLevel logLevel;
    private final File workingDir;
    private final Factory<File> envJsFactory;

    public EnvJsBrowserEvaluator(RhinoWorkerHandleFactory rhinoWorkerHandleFactory, Iterable<File> rhinoClasspath, Factory<File> envJsFactory, LogLevel logLevel, File workingDir) {
        this.rhinoWorkerHandleFactory = rhinoWorkerHandleFactory;
        this.rhinoClasspath = rhinoClasspath;
        this.envJsFactory = envJsFactory;
        this.logLevel = logLevel;
        this.workingDir = workingDir;
    }

    @Override
    public void evaluate(String url, Writer writer) {
        RequestHandler evaluator = this.rhinoWorkerHandleFactory.create(this.rhinoClasspath, EnvJsEvaluateWorker.class, this.logLevel, this.workingDir);
        String result = (String)evaluator.run(new EnvJsEvaluateSpec(this.envJsFactory.create(), url));
        try {
            IOUtils.copy((Reader)new StringReader(result), writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

