/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.jshint;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.plugins.javascript.jshint.internal.JsHintResult;
import org.gradle.plugins.javascript.jshint.internal.JsHintSpec;
import org.gradle.plugins.javascript.jshint.internal.JsHintWorker;
import org.gradle.plugins.javascript.rhino.worker.internal.DefaultRhinoWorkerHandleFactory;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class JsHint
extends SourceTask {
    private Object rhinoClasspath;
    private Object jsHint;
    private String encoding = "UTF-8";
    private Object jsonReport;
    private LogLevel logLevel = this.getProject().getGradle().getStartParameter().getLogLevel();
    private File projectDir = this.getProject().getProjectDir();

    @Inject
    protected WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getRhinoClasspath() {
        return this.getObjectFactory().fileCollection().from(this.rhinoClasspath);
    }

    public void setRhinoClasspath(FileCollection rhinoClasspath) {
        this.rhinoClasspath = rhinoClasspath;
    }

    public void setRhinoClasspath(Object rhinoClasspath) {
        this.rhinoClasspath = rhinoClasspath;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getJsHint() {
        return this.getObjectFactory().fileCollection().from(this.jsHint);
    }

    public void setJsHint(FileCollection jsHint) {
        this.jsHint = jsHint;
    }

    public void setJsHint(Object jsHint) {
        this.jsHint = jsHint;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @OutputFile
    public File getJsonReport() {
        return this.jsonReport == null ? null : this.getProject().file(this.jsonReport);
    }

    public void setJsonReport(File jsonReport) {
        this.jsonReport = jsonReport;
    }

    public void setJsonReport(Object jsonReport) {
        this.jsonReport = jsonReport;
    }

    @TaskAction
    public void doJsHint() {
        DefaultRhinoWorkerHandleFactory handleFactory = new DefaultRhinoWorkerHandleFactory(this.getWorkerProcessBuilderFactory());
        RequestHandler worker = handleFactory.create(this.getRhinoClasspath(), JsHintWorker.class, this.logLevel, this.projectDir);
        JsHintSpec spec = new JsHintSpec();
        spec.setSource(this.getSource().getFiles());
        spec.setEncoding(this.getEncoding());
        spec.setJsHint(this.getJsHint().getSingleFile());
        JsHintResult result = (JsHintResult)worker.run(spec);
        this.setDidWork(true);
        Logger logger = this.getLogger();
        boolean anyErrors = false;
        LinkedHashMap<String, Map<String, Object>> reportData = new LinkedHashMap<String, Map<String, Object>>(result.getResults().size());
        for (Map.Entry<File, Map<String, Object>> fileEntry : result.getResults().entrySet()) {
            File file = fileEntry.getKey();
            Map<String, Object> data = fileEntry.getValue();
            reportData.put(file.getAbsolutePath(), data);
            if (!data.containsKey("errors")) continue;
            anyErrors = true;
            URI projectDirUri = this.projectDir.toURI();
            Map errors = (Map)data.get("errors");
            if (errors.isEmpty()) continue;
            URI relativePath = projectDirUri.relativize(file.toURI());
            logger.warn("JsHint errors for file: {}", (Object)relativePath.getPath());
            for (Map.Entry errorEntry : errors.entrySet()) {
                Map error = (Map)errorEntry.getValue();
                int line = Float.valueOf(error.get("line").toString()).intValue();
                int character = Float.valueOf(error.get("character").toString()).intValue();
                String reason = error.get("reason").toString();
                logger.warn("  {}:{} > {}", line, character, reason);
            }
        }
        File jsonReportFile = this.getJsonReport();
        if (jsonReportFile != null) {
            try {
                FileWriter reportWriter = new FileWriter(jsonReportFile);
                new GsonBuilder().setPrettyPrinting().create().toJson(reportData, (Appendable)reportWriter);
                reportWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (anyErrors) {
            throw new GradleException("JsHint detected errors");
        }
    }
}

