/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GUtil;

public class ProcessArgumentsSpec {
    private final HasExecutable hasExecutable;
    private final List<Object> arguments = new ArrayList<Object>();
    private final List<CommandLineArgumentProvider> argumentProviders = new ArrayList<CommandLineArgumentProvider>();

    public ProcessArgumentsSpec(HasExecutable hasExecutable) {
        this.hasExecutable = hasExecutable;
    }

    public List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.hasExecutable.getExecutable());
        commandLine.addAll(this.getAllArguments());
        return commandLine;
    }

    public ProcessArgumentsSpec commandLine(Object ... arguments) {
        this.commandLine(Arrays.asList(arguments));
        return this;
    }

    public ProcessArgumentsSpec commandLine(Iterable<?> args) {
        ArrayList<?> argsList = Lists.newArrayList(args);
        this.hasExecutable.setExecutable(argsList.get(0));
        this.setArgs(argsList.subList(1, argsList.size()));
        return this;
    }

    public List<String> getAllArguments() {
        List<String> args = this.getArgs();
        ArrayList<Object> allArgs = args == null ? new ArrayList() : new ArrayList<String>(args);
        for (CommandLineArgumentProvider argumentProvider : this.argumentProviders) {
            Iterables.addAll(allArgs, argumentProvider.asArguments());
        }
        return allArgs;
    }

    public ProcessArgumentsSpec args(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.args(Arrays.asList(args));
        return this;
    }

    public ProcessArgumentsSpec args(Iterable<?> args) {
        GUtil.addToCollection(this.arguments, true, args);
        return this;
    }

    public ProcessArgumentsSpec setArgs(List<String> arguments) {
        this.arguments.clear();
        this.args(arguments);
        return this;
    }

    public ProcessArgumentsSpec setArgs(Iterable<?> arguments) {
        this.arguments.clear();
        this.args(arguments);
        return this;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object argument : this.arguments) {
            args.add(argument.toString());
        }
        return args;
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentProviders;
    }

    static interface HasExecutable {
        public String getExecutable();

        public void setExecutable(Object var1);
    }
}

