/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;

@ThreadSafe
public class ClassLoaderCache {
    private final Lock lock = new ReentrantLock();
    private final Cache<ClassLoader, ClassLoaderDetails> classLoaderDetails = CacheBuilder.newBuilder().weakKeys().build();
    private final Cache<UUID, ClassLoader> classLoaderIds = CacheBuilder.newBuilder().softValues().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ClassLoaderDetails details, Transformer<ClassLoader, ClassLoaderDetails> factory) {
        this.lock.lock();
        try {
            ClassLoader classLoader = this.classLoaderIds.getIfPresent(details.uuid);
            if (classLoader != null) {
                ClassLoader classLoader2 = classLoader;
                return classLoader2;
            }
            classLoader = factory.transform(details);
            this.classLoaderIds.put(details.uuid, classLoader);
            this.classLoaderDetails.put(classLoader, details);
            ClassLoader classLoader3 = classLoader;
            return classLoader3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public ClassLoaderDetails maybeGetDetails(ClassLoader classLoader) {
        this.lock.lock();
        try {
            ClassLoaderDetails classLoaderDetails = this.classLoaderDetails.getIfPresent(classLoader);
            return classLoaderDetails;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoaderDetails getDetails(ClassLoader classLoader, Transformer<ClassLoaderDetails, ClassLoader> factory) {
        this.lock.lock();
        try {
            ClassLoaderDetails details = this.classLoaderDetails.getIfPresent(classLoader);
            if (details != null) {
                ClassLoaderDetails classLoaderDetails = details;
                return classLoaderDetails;
            }
            details = factory.transform(classLoader);
            this.classLoaderDetails.put(classLoader, details);
            this.classLoaderIds.put(details.uuid, classLoader);
            ClassLoaderDetails classLoaderDetails = details;
            return classLoaderDetails;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            for (ClassLoader classLoader : this.classLoaderDetails.asMap().keySet()) {
                ClassLoaderUtils.tryClose(classLoader);
            }
            this.classLoaderDetails.invalidateAll();
            this.classLoaderIds.invalidateAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

