/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry,
ToolingModelBuilderLookup {
    private final ToolingModelBuilderLookup parent;
    private final List<ToolingModelBuilder> builders = new ArrayList<ToolingModelBuilder>();
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry) {
        this(buildOperationExecutor, projectStateRegistry, null);
        this.register(new VoidToolingModelBuilder());
    }

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry, ToolingModelBuilderLookup parent) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectStateRegistry = projectStateRegistry;
        this.parent = parent;
    }

    @Override
    public void register(ToolingModelBuilder builder) {
        this.builders.add(builder);
    }

    @Override
    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilder builder = this.get(modelName);
        return new LenientToolingModelBuilder(builder);
    }

    @Override
    public ToolingModelBuilderLookup.Builder locateForClientOperation(String modelName, boolean parameter, GradleInternal target) throws UnknownModelException {
        ProjectInternal project = target.getDefaultProject();
        return new BuildOperationWrappingBuilder(new LockAllProjectsBuilder(this.locateForClientOperation(modelName, project, parameter), this.projectStateRegistry), modelName, project, this.buildOperationExecutor);
    }

    @Override
    public ToolingModelBuilderLookup.Builder locateForClientOperation(String modelName, boolean parameter, ProjectInternal target) throws UnknownModelException {
        return new BuildOperationWrappingBuilder(new LockSingleProjectBuilder(this.locateForClientOperation(modelName, target, parameter), target, this.projectStateRegistry), modelName, target, this.buildOperationExecutor);
    }

    private ToolingModelBuilderLookup.Builder locateForClientOperation(String modelName, ProjectInternal project, boolean parameter) throws UnknownModelException {
        ToolingModelBuilder builder = this.get(modelName);
        if (builder instanceof ParameterizedToolingModelBuilder) {
            return new BuilderWithParameter(modelName, project, (ParameterizedToolingModelBuilder)builder);
        }
        if (parameter) {
            throw new UnknownModelException(String.format("No parameterized builders are available to build a model of type '%s'.", modelName));
        }
        return new BuilderWithNoParameter(modelName, project, builder);
    }

    @Override
    @Nullable
    public ToolingModelBuilder find(String modelName) {
        ToolingModelBuilder match = null;
        for (ToolingModelBuilder builder : this.builders) {
            if (!builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = builder;
        }
        if (match != null) {
            return match;
        }
        if (this.parent != null) {
            return this.parent.find(modelName);
        }
        return null;
    }

    private ToolingModelBuilder get(String modelName) {
        ToolingModelBuilder builder = this.find(modelName);
        if (builder != null) {
            return builder;
        }
        throw new UnknownModelException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        @Override
        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        @Override
        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }

    private static class BuildOperationWrappingBuilder
    extends DelegatingBuilder {
        private final String modelName;
        private final ProjectInternal project;
        private final BuildOperationExecutor buildOperationExecutor;

        private BuildOperationWrappingBuilder(ToolingModelBuilderLookup.Builder delegate, String modelName, ProjectInternal project, BuildOperationExecutor buildOperationExecutor) {
            super(delegate);
            this.modelName = modelName;
            this.project = project;
            this.buildOperationExecutor = buildOperationExecutor;
        }

        @Override
        public Object build(final Object parameter) {
            return this.buildOperationExecutor.call(new CallableBuildOperation<Object>(){

                @Override
                public Object call(BuildOperationContext context) {
                    return delegate.build(parameter);
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Build model '" + modelName + "' for " + project.getDisplayName()).progressDisplayName("Building model '" + modelName + "'");
                }
            });
        }
    }

    private static class LockAllProjectsBuilder
    extends DelegatingBuilder {
        private final ProjectStateRegistry projectStateRegistry;

        public LockAllProjectsBuilder(ToolingModelBuilderLookup.Builder delegate, ProjectStateRegistry projectStateRegistry) {
            super(delegate);
            this.projectStateRegistry = projectStateRegistry;
        }

        @Override
        public Object build(Object parameter) {
            return this.projectStateRegistry.withMutableStateOfAllProjects(() -> this.delegate.build(parameter));
        }
    }

    private static class LockSingleProjectBuilder
    extends DelegatingBuilder {
        private final ProjectInternal project;
        private final ProjectStateRegistry projectStateRegistry;

        public LockSingleProjectBuilder(ToolingModelBuilderLookup.Builder delegate, ProjectInternal project, ProjectStateRegistry projectStateRegistry) {
            super(delegate);
            this.project = project;
            this.projectStateRegistry = projectStateRegistry;
        }

        @Override
        public Object build(Object parameter) {
            return this.projectStateRegistry.stateFor(this.project).fromMutableState(p -> this.delegate.build(parameter));
        }
    }

    private static class BuilderWithParameter
    implements ToolingModelBuilderLookup.Builder {
        private final String modelName;
        private final ProjectInternal project;
        private final ParameterizedToolingModelBuilder<?> delegate;

        public BuilderWithParameter(String modelName, ProjectInternal project, ParameterizedToolingModelBuilder<?> delegate) {
            this.modelName = modelName;
            this.project = project;
            this.delegate = delegate;
        }

        @Override
        public Class<?> getParameterType() {
            return this.delegate.getParameterType();
        }

        @Override
        public Object build(Object parameter) {
            if (parameter == null) {
                return this.delegate.buildAll(this.modelName, this.project);
            }
            return this.delegate.buildAll(this.modelName, Cast.uncheckedCast(parameter), this.project);
        }
    }

    private static class BuilderWithNoParameter
    implements ToolingModelBuilderLookup.Builder {
        private final String modelName;
        private final ProjectInternal project;
        private final ToolingModelBuilder delegate;

        public BuilderWithNoParameter(String modelName, ProjectInternal project, ToolingModelBuilder delegate) {
            this.modelName = modelName;
            this.project = project;
            this.delegate = delegate;
        }

        public Class<Object> getParameterType() {
            return null;
        }

        @Override
        public Object build(Object parameter) {
            if (parameter != null) {
                throw new IllegalArgumentException("Expected a null parameter");
            }
            return this.delegate.buildAll(this.modelName, this.project);
        }
    }

    private static abstract class DelegatingBuilder
    implements ToolingModelBuilderLookup.Builder {
        final ToolingModelBuilderLookup.Builder delegate;

        public DelegatingBuilder(ToolingModelBuilderLookup.Builder delegate) {
            this.delegate = delegate;
        }

        @Override
        public Class<?> getParameterType() {
            return this.delegate.getParameterType();
        }
    }

    private class LenientToolingModelBuilder
    implements ToolingModelBuilder {
        private final ToolingModelBuilder delegate;

        public LenientToolingModelBuilder(ToolingModelBuilder delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        @Override
        public Object buildAll(String modelName, Project project) {
            return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.allowUncontrolledAccessToAnyProject(() -> this.delegate.buildAll(modelName, project));
        }
    }
}

