/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptions {
    private final JavaForkOptionsInternal forkOptions;
    private final KeepAliveMode keepAliveMode;
    private final ClassLoaderStructure classLoaderStructure;

    DaemonForkOptions(JavaForkOptionsInternal forkOptions, KeepAliveMode keepAliveMode, ClassLoaderStructure classLoaderStructure) {
        this.forkOptions = forkOptions;
        this.keepAliveMode = keepAliveMode;
        this.classLoaderStructure = classLoaderStructure;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.keepAliveMode;
    }

    public JavaForkOptions getJavaForkOptions() {
        return this.forkOptions;
    }

    public ClassLoaderStructure getClassLoaderStructure() {
        return this.classLoaderStructure;
    }

    public boolean isCompatibleWith(DaemonForkOptions other) {
        return this.forkOptions.isCompatibleWith(other.forkOptions) && this.keepAliveMode == other.getKeepAliveMode() && Objects.equal(this.classLoaderStructure, other.getClassLoaderStructure());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("executable", this.forkOptions.getExecutable()).add("minHeapSize", this.forkOptions.getMinHeapSize()).add("maxHeapSize", this.forkOptions.getMaxHeapSize()).add("jvmArgs", this.forkOptions.getJvmArgs()).add("keepAliveMode", (Object)this.keepAliveMode).toString();
    }
}

