/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.internal.health.memory.MaximumHeapHelper;
import org.gradle.process.internal.health.memory.MemoryAmount;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientsManager;

public class WorkerDaemonExpiration
implements MemoryHolder {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonExpiration.class);
    private final WorkerDaemonClientsManager clientsManager;
    private final long osTotalMemory;

    public WorkerDaemonExpiration(WorkerDaemonClientsManager clientsManager, long osTotalMemory) {
        this.clientsManager = clientsManager;
        this.osTotalMemory = osTotalMemory;
    }

    @Override
    public long attemptToRelease(long memoryAmountBytes) throws IllegalArgumentException {
        if (memoryAmountBytes < 0L) {
            throw new IllegalArgumentException("Negative memory amount");
        }
        LOGGER.debug("Will attempt to release {} of memory", (Object)(memoryAmountBytes / 1024L / 1024L));
        SimpleMemoryExpirationSelector selector = new SimpleMemoryExpirationSelector(memoryAmountBytes);
        this.clientsManager.selectIdleClientsToStop(selector);
        return selector.getReleasedBytes();
    }

    private class SimpleMemoryExpirationSelector
    implements Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> {
        private final long memoryBytesToRelease;
        private long releasedBytes;

        public SimpleMemoryExpirationSelector(long memoryBytesToRelease) {
            this.memoryBytesToRelease = memoryBytesToRelease;
        }

        public long getReleasedBytes() {
            return this.releasedBytes;
        }

        @Override
        public List<WorkerDaemonClient> transform(List<WorkerDaemonClient> idleClients) {
            int notExpirable = 0;
            ArrayList<WorkerDaemonClient> toExpire = new ArrayList<WorkerDaemonClient>();
            for (WorkerDaemonClient idleClient : idleClients) {
                if (idleClient.isNotExpirable()) {
                    ++notExpirable;
                    continue;
                }
                toExpire.add(idleClient);
                long freed = this.getMemoryUsage(idleClient);
                this.releasedBytes += freed;
                if (this.releasedBytes < this.memoryBytesToRelease) continue;
                break;
            }
            if (LOGGER.isDebugEnabled() && !toExpire.isEmpty()) {
                LOGGER.debug("Worker Daemon(s) expired to free some system memory {}", (Object)toExpire.size());
            }
            if (notExpirable > 0) {
                LOGGER.debug("{} Worker Daemon(s) had expiration disabled and were skipped", (Object)notExpirable);
            }
            return toExpire;
        }

        private long getMemoryUsage(WorkerDaemonClient idleClient) {
            try {
                return idleClient.getJvmMemoryStatus().getCommittedMemory();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            String forkOptionsMaxHeapSize = idleClient.getForkOptions().getJavaForkOptions().getMaxHeapSize();
            long parsed = MemoryAmount.parseNotation(forkOptionsMaxHeapSize);
            if (parsed != -1L) {
                return parsed;
            }
            if (WorkerDaemonExpiration.this.osTotalMemory != -1L) {
                return new MaximumHeapHelper().getDefaultMaximumHeapSize(WorkerDaemonExpiration.this.osTotalMemory);
            }
            return 0L;
        }
    }
}

