/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.List;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.DirEntry;
import net.rubygrapefruit.platform.file.WindowsFileInfo;
import net.rubygrapefruit.platform.file.WindowsFiles;
import net.rubygrapefruit.platform.internal.AbstractFiles;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.WindowsDirList;
import net.rubygrapefruit.platform.internal.WindowsFileStat;
import net.rubygrapefruit.platform.internal.jni.WindowsFileFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWindowsFiles
extends AbstractFiles
implements WindowsFiles {
    @Override
    public WindowsFileInfo stat(File file) throws NativeException {
        return this.stat(file, false);
    }

    @Override
    public WindowsFileInfo stat(File file, boolean linkTarget) throws NativeException {
        FunctionResult result = new FunctionResult();
        WindowsFileStat stat = new WindowsFileStat(file.getPath());
        WindowsFileFunctions.stat(file.getPath(), linkTarget, stat, result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not get file details of %s: %s", file, result.getMessage()));
        }
        return stat;
    }

    @Override
    public List<? extends DirEntry> listDir(File dir2, boolean linkTarget) throws NativeException {
        FunctionResult result = new FunctionResult();
        WindowsDirList dirList = new WindowsDirList();
        WindowsFileFunctions.readdir(dir2.getPath(), linkTarget, dirList, result);
        if (result.isFailed()) {
            throw this.listDirFailure(dir2, result);
        }
        return dirList.files;
    }

    @Override
    public List<? extends DirEntry> listDir(File dir2) throws NativeException {
        return this.listDir(dir2, false);
    }
}

