/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.IgnoredTestListener;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.util.FileUtils;
import org.gradle.internal.impldep.junit.framework.AssertionFailedError;
import org.gradle.internal.impldep.junit.framework.Test;

public class BriefJUnitResultFormatter
implements JUnitResultFormatter,
IgnoredTestListener {
    private static final double ONE_SECOND = 1000.0;
    private OutputStream out;
    private BufferedWriter output;
    private StringWriter results;
    private BufferedWriter resultWriter;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private String systemOutput = null;
    private String systemError = null;

    public BriefJUnitResultFormatter() {
        this.results = new StringWriter();
        this.resultWriter = new BufferedWriter(this.results);
    }

    @Override
    public void setOutput(OutputStream out) {
        this.out = out;
        this.output = new BufferedWriter(new OutputStreamWriter(out));
    }

    @Override
    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    @Override
    public void setSystemError(String err) {
        this.systemError = err;
    }

    @Override
    public void startTestSuite(JUnitTest suite) {
        if (this.output == null) {
            return;
        }
        try {
            this.output.write(String.format("Testsuite: %s%n", suite.getName()));
            this.output.flush();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    @Override
    public void endTestSuite(JUnitTest suite) {
        StringBuilder sb = new StringBuilder("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Skipped: ");
        sb.append(suite.skipCount());
        sb.append(", Time elapsed: ");
        sb.append(this.numberFormat.format((double)suite.getRunTime() / 1000.0));
        sb.append(String.format(" sec%n%n", new Object[0]));
        if (this.systemOutput != null && !this.systemOutput.isEmpty()) {
            sb.append(String.format("------------- Standard Output ---------------%n", new Object[0]));
            sb.append(this.systemOutput);
            sb.append(String.format("------------- ---------------- ---------------%n", new Object[0]));
        }
        if (this.systemError != null && !this.systemError.isEmpty()) {
            sb.append(String.format("------------- Standard Error -----------------%n", new Object[0]));
            sb.append(this.systemError);
            sb.append(String.format("------------- ---------------- ---------------%n", new Object[0]));
        }
        if (this.output != null) {
            try {
                this.output.write(sb.toString());
                this.resultWriter.close();
                this.output.write(this.results.toString());
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
            finally {
                try {
                    this.output.flush();
                }
                catch (IOException iOException) {}
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close(this.out);
                }
            }
        }
    }

    @Override
    public void startTest(Test test) {
    }

    @Override
    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)((Object)t));
    }

    @Override
    public void addError(Test test, Throwable error) {
        this.formatError("\tCaused an ERROR", test, error);
    }

    protected String formatTest(Test test) {
        if (test == null) {
            return "Null Test: ";
        }
        return "Testcase: " + test.toString() + ":";
    }

    protected synchronized void formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
        }
        try {
            this.resultWriter.write(this.formatTest(test) + type);
            this.resultWriter.newLine();
            this.resultWriter.write(String.valueOf(error.getMessage()));
            this.resultWriter.newLine();
            String strace = JUnitTestRunner.getFilteredTrace(error);
            this.resultWriter.write(strace);
            this.resultWriter.newLine();
            this.resultWriter.newLine();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    @Override
    public void testIgnored(Test test) {
        this.formatSkip(test, JUnitVersionHelper.getIgnoreMessage(test));
    }

    public void formatSkip(Test test, String message2) {
        if (test != null) {
            this.endTest(test);
        }
        try {
            this.resultWriter.write(this.formatTest(test) + "SKIPPED");
            if (message2 != null) {
                this.resultWriter.write(": ");
                this.resultWriter.write(message2);
            }
            this.resultWriter.newLine();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    @Override
    public void testAssumptionFailure(Test test, Throwable cause) {
        this.formatSkip(test, cause.getMessage());
    }
}

