/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.CompositeInitScriptFinder;
import org.gradle.initialization.DistributionInitScriptFinder;
import org.gradle.initialization.UserHomeInitScriptFinder;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.FileUtils;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.builder.EqualsBuilder;
import org.gradle.internal.impldep.org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.internal.logging.DefaultLoggingConfiguration;

public class StartParameter
implements LoggingConfiguration,
ParallelismConfiguration,
Serializable {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final File DEFAULT_GRADLE_USER_HOME = new BuildLayoutParameters().getGradleUserHomeDir();
    private final DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
    private final DefaultParallelismConfiguration parallelismConfiguration = new DefaultParallelismConfiguration();
    private List<TaskExecutionRequest> taskRequests = new ArrayList<TaskExecutionRequest>();
    private Set<String> excludedTaskNames = new LinkedHashSet<String>();
    private boolean buildProjectDependencies = true;
    private File currentDir;
    private File projectDir;
    private Map<String, String> projectProperties = new HashMap<String, String>();
    private Map<String, String> systemPropertiesArgs = new HashMap<String, String>();
    private File gradleUserHomeDir;
    protected File gradleHomeDir;
    private File settingsFile;
    private File buildFile;
    private List<File> initScripts = new ArrayList<File>();
    private boolean dryRun;
    private boolean rerunTasks;
    private boolean profile;
    private boolean continueOnFailure;
    private boolean offline;
    private File projectCacheDir;
    private boolean refreshDependencies;
    private boolean buildCacheEnabled;
    private boolean buildCacheDebugLogging;
    private boolean configureOnDemand;
    private boolean continuous;
    private List<File> includedBuilds = new ArrayList<File>();
    private boolean buildScan;
    private boolean noBuildScan;
    private boolean writeDependencyLocks;
    private List<String> writeDependencyVerifications = Collections.emptyList();
    private List<String> lockedDependenciesToUpdate = Collections.emptyList();
    private DependencyVerificationMode verificationMode = DependencyVerificationMode.STRICT;
    private boolean isRefreshKeys;
    private boolean isExportKeys;

    @Override
    public LogLevel getLogLevel() {
        return this.loggingConfiguration.getLogLevel();
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.loggingConfiguration.setLogLevel(logLevel);
    }

    @Override
    public ShowStacktrace getShowStacktrace() {
        return this.loggingConfiguration.getShowStacktrace();
    }

    @Override
    public void setShowStacktrace(ShowStacktrace showStacktrace) {
        this.loggingConfiguration.setShowStacktrace(showStacktrace);
    }

    @Override
    public ConsoleOutput getConsoleOutput() {
        return this.loggingConfiguration.getConsoleOutput();
    }

    @Override
    public void setConsoleOutput(ConsoleOutput consoleOutput) {
        this.loggingConfiguration.setConsoleOutput(consoleOutput);
    }

    @Override
    public WarningMode getWarningMode() {
        return this.loggingConfiguration.getWarningMode();
    }

    @Override
    public void setWarningMode(WarningMode warningMode) {
        this.loggingConfiguration.setWarningMode(warningMode);
    }

    public void setProjectCacheDir(@Nullable File projectCacheDir) {
        this.projectCacheDir = projectCacheDir;
    }

    @Nullable
    public File getProjectCacheDir() {
        return this.projectCacheDir;
    }

    public StartParameter() {
        this(new BuildLayoutParameters());
    }

    protected StartParameter(BuildLayoutParameters layoutParameters) {
        this.gradleHomeDir = layoutParameters.getGradleInstallationHomeDir();
        this.currentDir = layoutParameters.getCurrentDir();
        this.projectDir = layoutParameters.getProjectDir();
        this.gradleUserHomeDir = layoutParameters.getGradleUserHomeDir();
    }

    public StartParameter newInstance() {
        return this.prepareNewInstance(new StartParameter());
    }

    protected StartParameter prepareNewInstance(StartParameter p) {
        this.prepareNewBuild(p);
        p.setWarningMode(this.getWarningMode());
        p.buildFile = this.buildFile;
        p.projectDir = this.projectDir;
        p.settingsFile = this.settingsFile;
        p.taskRequests = new ArrayList<TaskExecutionRequest>(this.taskRequests);
        p.excludedTaskNames = new LinkedHashSet<String>(this.excludedTaskNames);
        p.buildProjectDependencies = this.buildProjectDependencies;
        p.currentDir = this.currentDir;
        p.projectProperties = new HashMap<String, String>(this.projectProperties);
        p.systemPropertiesArgs = new HashMap<String, String>(this.systemPropertiesArgs);
        p.initScripts = new ArrayList<File>(this.initScripts);
        p.includedBuilds = new ArrayList<File>(this.includedBuilds);
        p.dryRun = this.dryRun;
        p.projectCacheDir = this.projectCacheDir;
        return p;
    }

    public StartParameter newBuild() {
        return this.prepareNewBuild(new StartParameter());
    }

    protected StartParameter prepareNewBuild(StartParameter p) {
        p.gradleUserHomeDir = this.gradleUserHomeDir;
        p.gradleHomeDir = this.gradleHomeDir;
        p.setLogLevel(this.getLogLevel());
        p.setConsoleOutput(this.getConsoleOutput());
        p.setShowStacktrace(this.getShowStacktrace());
        p.setWarningMode(this.getWarningMode());
        p.profile = this.profile;
        p.continueOnFailure = this.continueOnFailure;
        p.offline = this.offline;
        p.rerunTasks = this.rerunTasks;
        p.refreshDependencies = this.refreshDependencies;
        p.setParallelProjectExecutionEnabled(this.isParallelProjectExecutionEnabled());
        p.buildCacheEnabled = this.buildCacheEnabled;
        p.configureOnDemand = this.configureOnDemand;
        p.setMaxWorkerCount(this.getMaxWorkerCount());
        p.systemPropertiesArgs = new HashMap<String, String>(this.systemPropertiesArgs);
        p.writeDependencyLocks = this.writeDependencyLocks;
        p.writeDependencyVerifications = this.writeDependencyVerifications;
        p.lockedDependenciesToUpdate = new ArrayList<String>(this.lockedDependenciesToUpdate);
        p.verificationMode = this.verificationMode;
        p.isRefreshKeys = this.isRefreshKeys;
        p.isExportKeys = this.isExportKeys;
        return p;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Nullable
    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(@Nullable File buildFile) {
        if (buildFile == null) {
            this.buildFile = null;
            this.setCurrentDir(null);
        } else {
            this.buildFile = FileUtils.canonicalize(buildFile);
            this.setProjectDir(this.buildFile.getParentFile());
        }
    }

    public List<String> getTaskNames() {
        ArrayList<String> taskNames = Lists.newArrayList();
        for (TaskExecutionRequest taskRequest : this.taskRequests) {
            taskNames.addAll(taskRequest.getArgs());
        }
        return taskNames;
    }

    public void setTaskNames(@Nullable Iterable<String> taskNames) {
        this.taskRequests = taskNames == null ? Collections.emptyList() : Arrays.asList(new DefaultTaskExecutionRequest(taskNames));
    }

    public List<TaskExecutionRequest> getTaskRequests() {
        return this.taskRequests;
    }

    public void setTaskRequests(Iterable<? extends TaskExecutionRequest> taskParameters) {
        this.taskRequests = Lists.newArrayList(taskParameters);
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public void setExcludedTaskNames(Iterable<String> excludedTaskNames) {
        this.excludedTaskNames = Sets.newLinkedHashSet(excludedTaskNames);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(@Nullable File currentDir) {
        this.currentDir = currentDir != null ? FileUtils.canonicalize(currentDir) : new BuildLayoutParameters().getCurrentDir();
    }

    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = projectProperties;
    }

    public Map<String, String> getSystemPropertiesArgs() {
        return this.systemPropertiesArgs;
    }

    public void setSystemPropertiesArgs(Map<String, String> systemPropertiesArgs) {
        this.systemPropertiesArgs = systemPropertiesArgs;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(@Nullable File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir == null ? new BuildLayoutParameters().getGradleUserHomeDir() : FileUtils.canonicalize(gradleUserHomeDir);
    }

    public boolean isBuildProjectDependencies() {
        return this.buildProjectDependencies;
    }

    public StartParameter setBuildProjectDependencies(boolean build) {
        this.buildProjectDependencies = build;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setSettingsFile(@Nullable File settingsFile) {
        if (settingsFile == null) {
            this.settingsFile = null;
        } else {
            this.settingsFile = FileUtils.canonicalize(settingsFile);
            this.currentDir = this.settingsFile.getParentFile();
        }
    }

    @Nullable
    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void addInitScript(File initScriptFile) {
        this.initScripts.add(initScriptFile);
    }

    public void setInitScripts(List<File> initScripts) {
        this.initScripts = initScripts;
    }

    public List<File> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    public List<File> getAllInitScripts() {
        CompositeInitScriptFinder initScriptFinder = new CompositeInitScriptFinder(new UserHomeInitScriptFinder(this.getGradleUserHomeDir()), new DistributionInitScriptFinder(this.gradleHomeDir));
        ArrayList<File> scripts = new ArrayList<File>(this.getInitScripts());
        initScriptFinder.findScripts(scripts);
        return Collections.unmodifiableList(scripts);
    }

    public void setProjectDir(@Nullable File projectDir) {
        if (projectDir == null) {
            this.setCurrentDir(null);
            this.projectDir = null;
        } else {
            File canonicalFile;
            this.currentDir = canonicalFile = FileUtils.canonicalize(projectDir);
            this.projectDir = canonicalFile;
        }
    }

    @Nullable
    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isRefreshDependencies() {
        return this.refreshDependencies;
    }

    public void setRefreshDependencies(boolean refreshDependencies) {
        this.refreshDependencies = refreshDependencies;
    }

    public boolean isRerunTasks() {
        return this.rerunTasks;
    }

    public void setRerunTasks(boolean rerunTasks) {
        this.rerunTasks = rerunTasks;
    }

    @Override
    public boolean isParallelProjectExecutionEnabled() {
        return this.parallelismConfiguration.isParallelProjectExecutionEnabled();
    }

    @Override
    public void setParallelProjectExecutionEnabled(boolean parallelProjectExecution) {
        this.parallelismConfiguration.setParallelProjectExecutionEnabled(parallelProjectExecution);
    }

    public boolean isBuildCacheEnabled() {
        return this.buildCacheEnabled;
    }

    public void setBuildCacheEnabled(boolean buildCacheEnabled) {
        this.buildCacheEnabled = buildCacheEnabled;
    }

    public boolean isBuildCacheDebugLogging() {
        return this.buildCacheDebugLogging;
    }

    public void setBuildCacheDebugLogging(boolean buildCacheDebugLogging) {
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    @Override
    public int getMaxWorkerCount() {
        return this.parallelismConfiguration.getMaxWorkerCount();
    }

    @Override
    public void setMaxWorkerCount(int maxWorkerCount) {
        this.parallelismConfiguration.setMaxWorkerCount(maxWorkerCount);
    }

    @Incubating
    public boolean isConfigureOnDemand() {
        return this.configureOnDemand;
    }

    public String toString() {
        return "StartParameter{taskRequests=" + this.taskRequests + ", excludedTaskNames=" + this.excludedTaskNames + ", currentDir=" + this.currentDir + ", projectProperties=" + this.projectProperties + ", systemPropertiesArgs=" + this.systemPropertiesArgs + ", gradleUserHomeDir=" + this.gradleUserHomeDir + ", gradleHome=" + this.gradleHomeDir + ", logLevel=" + (Object)((Object)this.getLogLevel()) + ", showStacktrace=" + (Object)((Object)this.getShowStacktrace()) + ", buildFile=" + this.buildFile + ", initScripts=" + this.initScripts + ", dryRun=" + this.dryRun + ", rerunTasks=" + this.rerunTasks + ", offline=" + this.offline + ", refreshDependencies=" + this.refreshDependencies + ", parallelProjectExecution=" + this.isParallelProjectExecutionEnabled() + ", configureOnDemand=" + this.configureOnDemand + ", maxWorkerCount=" + this.getMaxWorkerCount() + ", buildCacheEnabled=" + this.buildCacheEnabled + ", writeDependencyLocks=" + this.writeDependencyLocks + ", verificationMode=" + (Object)((Object)this.verificationMode) + ", refreshKeys=" + this.isRefreshKeys + '}';
    }

    void setGradleHomeDir(File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    @Incubating
    public void setConfigureOnDemand(boolean configureOnDemand) {
        this.configureOnDemand = configureOnDemand;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean enabled) {
        this.continuous = enabled;
    }

    public void includeBuild(File includedBuild) {
        this.includedBuilds.add(includedBuild);
    }

    public void setIncludedBuilds(List<File> includedBuilds) {
        this.includedBuilds = includedBuilds;
    }

    public List<File> getIncludedBuilds() {
        return Collections.unmodifiableList(this.includedBuilds);
    }

    public boolean isBuildScan() {
        return this.buildScan;
    }

    public void setBuildScan(boolean buildScan) {
        this.buildScan = buildScan;
    }

    public boolean isNoBuildScan() {
        return this.noBuildScan;
    }

    public void setNoBuildScan(boolean noBuildScan) {
        this.noBuildScan = noBuildScan;
    }

    public void setWriteDependencyLocks(boolean writeDependencyLocks) {
        this.writeDependencyLocks = writeDependencyLocks;
    }

    public boolean isWriteDependencyLocks() {
        return this.writeDependencyLocks;
    }

    public void setLockedDependenciesToUpdate(List<String> lockedDependenciesToUpdate) {
        this.lockedDependenciesToUpdate = Lists.newArrayList(lockedDependenciesToUpdate);
        this.writeDependencyLocks = true;
    }

    public List<String> getWriteDependencyVerifications() {
        return this.writeDependencyVerifications;
    }

    public void setWriteDependencyVerifications(List<String> checksums) {
        this.writeDependencyVerifications = checksums;
    }

    public List<String> getLockedDependenciesToUpdate() {
        return this.lockedDependenciesToUpdate;
    }

    public void setDependencyVerificationMode(DependencyVerificationMode verificationMode) {
        this.verificationMode = verificationMode;
    }

    public DependencyVerificationMode getDependencyVerificationMode() {
        return this.verificationMode;
    }

    public void setRefreshKeys(boolean refresh) {
        this.isRefreshKeys = refresh;
    }

    public boolean isRefreshKeys() {
        return this.isRefreshKeys;
    }

    public boolean isExportKeys() {
        return this.isExportKeys;
    }

    public void setExportKeys(boolean exportKeys) {
        this.isExportKeys = exportKeys;
    }
}

