/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;

class ResolveConfigurationResolutionBuildOperationResult
implements ResolveConfigurationDependenciesBuildOperationType.Result,
CustomOperationTraceSerialization {
    private final ResolutionResult resolutionResult;
    private final AttributeContainer requestedAttributes;

    static ResolveConfigurationResolutionBuildOperationResult create(ResolutionResult resolutionResult, ImmutableAttributesFactory attributesFactory) {
        return new ResolveConfigurationResolutionBuildOperationResult(resolutionResult, new LazyDesugaringAttributeContainer(resolutionResult.getRequestedAttributes(), attributesFactory));
    }

    private ResolveConfigurationResolutionBuildOperationResult(ResolutionResult resolutionResult, AttributeContainer requestedAttributes) {
        this.resolutionResult = resolutionResult;
        this.requestedAttributes = requestedAttributes;
    }

    @Override
    public ResolvedComponentResult getRootComponent() {
        return this.resolutionResult.getRoot();
    }

    @Override
    public String getRepositoryId(ResolvedComponentResult resolvedComponentResult) {
        return ((ResolvedComponentResultInternal)resolvedComponentResult).getRepositoryName();
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("resolvedDependenciesCount", Integer.valueOf(this.getRootComponent().getDependencies().size()));
        HashMap components = Maps.newHashMap();
        this.resolutionResult.allComponents(component -> components.put(component.getId().getDisplayName(), Collections.singletonMap("repoName", ((ResolvedComponentResultInternal)component).getRepositoryName())));
        model.put("components", components);
        ImmutableList.Builder requestedAttributesBuilder = new ImmutableList.Builder();
        for (Attribute<?> att : this.requestedAttributes.keySet()) {
            requestedAttributesBuilder.add(ImmutableMap.of("name", att.getName(), "value", this.requestedAttributes.getAttribute(att).toString()));
        }
        model.put("requestedAttributes", requestedAttributesBuilder.build());
        return model;
    }

    @Override
    public AttributeContainer getRequestedAttributes() {
        return this.requestedAttributes;
    }

    private static final class LazyDesugaringAttributeContainer
    implements ImmutableAttributes {
        private final AttributeContainer source;
        private final ImmutableAttributesFactory attributesFactory;
        private ImmutableAttributes desugared;

        private LazyDesugaringAttributeContainer(@Nullable AttributeContainer source, ImmutableAttributesFactory attributesFactory) {
            this.source = source;
            this.attributesFactory = attributesFactory;
        }

        @Override
        public ImmutableSet<Attribute<?>> keySet() {
            return this.getDesugared().keySet();
        }

        @Override
        public <T> AttributeContainer attribute(Attribute<T> key, T value) {
            return this.getDesugared().attribute(key, value);
        }

        @Override
        @Nullable
        public <T> T getAttribute(Attribute<T> key) {
            return this.getDesugared().getAttribute(key);
        }

        @Override
        public boolean isEmpty() {
            return this.getDesugared().isEmpty();
        }

        @Override
        public boolean contains(Attribute<?> key) {
            return this.getDesugared().contains(key);
        }

        @Override
        public AttributeContainer getAttributes() {
            return this.getDesugared().getAttributes();
        }

        @Override
        public ImmutableAttributes asImmutable() {
            return this.getDesugared();
        }

        @Override
        public Map<Attribute<?>, ?> asMap() {
            return this.getDesugared().asMap();
        }

        @Override
        public <T> AttributeValue<T> findEntry(Attribute<T> key) {
            return this.getDesugared().findEntry(key);
        }

        @Override
        public AttributeValue<?> findEntry(String key) {
            return this.getDesugared().findEntry(key);
        }

        public String toString() {
            return this.getDesugared().toString();
        }

        public boolean equals(Object obj) {
            return this.getDesugared().equals(obj);
        }

        public int hashCode() {
            return this.getDesugared().hashCode();
        }

        private ImmutableAttributes getDesugared() {
            if (this.desugared == null) {
                this.desugarAttributes();
            }
            return this.desugared;
        }

        private void desugarAttributes() {
            AttributeContainerInternal result = this.attributesFactory.mutable();
            if (this.source != null) {
                for (Attribute<?> attribute : this.source.keySet()) {
                    String name = attribute.getName();
                    Class<?> type = attribute.getType();
                    Object attributeValue = this.source.getAttribute(attribute);
                    if (type.equals(Boolean.class)) {
                        result.attribute(attribute, (Boolean)attributeValue);
                        continue;
                    }
                    if (type.equals(String.class)) {
                        result.attribute(attribute, (String)attributeValue);
                        continue;
                    }
                    if (type.equals(Integer.class)) {
                        result.attribute(attribute, (Integer)attributeValue);
                        continue;
                    }
                    Attribute<String> stringAtt = Attribute.of(name, String.class);
                    String stringValue = attributeValue instanceof Named ? ((Named)attributeValue).getName() : (attributeValue instanceof Object[] ? Arrays.toString((Object[])attributeValue) : attributeValue.toString());
                    result.attribute(stringAtt, stringValue);
                }
            }
            this.desugared = result.asImmutable();
        }
    }
}

