/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultArtifactHandler
implements ArtifactHandler,
MethodMixIn {
    private final ConfigurationContainer configurationContainer;
    private final NotationParser<Object, ConfigurablePublishArtifact> publishArtifactFactory;
    private final DynamicMethods dynamicMethods;

    public DefaultArtifactHandler(ConfigurationContainer configurationContainer, NotationParser<Object, ConfigurablePublishArtifact> publishArtifactFactory) {
        this.configurationContainer = configurationContainer;
        this.publishArtifactFactory = publishArtifactFactory;
        this.dynamicMethods = new DynamicMethods();
    }

    private PublishArtifact pushArtifact(Configuration configuration, Object notation, Closure configureClosure) {
        Action configureAction = ConfigureUtil.configureUsing(configureClosure);
        return this.pushArtifact(configuration, notation, configureAction);
    }

    private PublishArtifact pushArtifact(Configuration configuration, Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        this.warnIfConfigurationIsDeprecated((DeprecatableConfiguration)configuration);
        ConfigurablePublishArtifact publishArtifact = this.publishArtifactFactory.parseNotation(notation);
        configuration.getArtifacts().add(publishArtifact);
        configureAction.execute(publishArtifact);
        return publishArtifact;
    }

    private void warnIfConfigurationIsDeprecated(DeprecatableConfiguration configuration) {
        if (configuration.isFullyDeprecated()) {
            ((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration(configuration.getName()).forArtifactDeclaration().replaceWith((List)GUtil.flattenElements(configuration.getDeclarationAlternatives(), configuration.getConsumptionAlternatives()))).willBecomeAnErrorInGradle8().withUpgradeGuideSection(5, "dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations").nagUser();
        }
    }

    @Override
    public PublishArtifact add(String configurationName, Object artifactNotation, Action<? super ConfigurablePublishArtifact> configureAction) {
        return this.pushArtifact(this.configurationContainer.getByName(configurationName), artifactNotation, configureAction);
    }

    @Override
    public PublishArtifact add(String configurationName, Object artifactNotation) {
        return this.pushArtifact(this.configurationContainer.getByName(configurationName), artifactNotation, Actions.doNothing());
    }

    @Override
    public PublishArtifact add(String configurationName, Object artifactNotation, Closure configureClosure) {
        return this.pushArtifact(this.configurationContainer.getByName(configurationName), artifactNotation, configureClosure);
    }

    @Override
    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    private class DynamicMethods
    implements MethodAccess {
        private DynamicMethods() {
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return arguments.length > 0 && DefaultArtifactHandler.this.configurationContainer.findByName(name) != null;
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (arguments.length == 0) {
                return DynamicInvokeResult.notFound();
            }
            Configuration configuration = (Configuration)DefaultArtifactHandler.this.configurationContainer.findByName(name);
            if (configuration == null) {
                return DynamicInvokeResult.notFound();
            }
            List<Object> normalizedArgs = GUtil.flatten(Arrays.asList(arguments), false);
            if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
                return DynamicInvokeResult.found(DefaultArtifactHandler.this.pushArtifact(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1)));
            }
            for (Object notation : normalizedArgs) {
                DefaultArtifactHandler.this.pushArtifact(configuration, notation, Actions.doNothing());
            }
            return DynamicInvokeResult.found();
        }
    }
}

