/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class PlatformSupport {
    private final Category library;
    private final Category regularPlatform;
    private final Category enforcedPlatform;

    public PlatformSupport(NamedObjectInstantiator instantiator) {
        this.library = instantiator.named(Category.class, "library");
        this.regularPlatform = instantiator.named(Category.class, "platform");
        this.enforcedPlatform = instantiator.named(Category.class, "enforced-platform");
    }

    public boolean isTargetingPlatform(HasConfigurableAttributes<?> target) {
        Category category = target.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return this.regularPlatform.equals(category) || this.enforcedPlatform.equals(category);
    }

    public Category getRegularPlatformCategory() {
        return this.regularPlatform;
    }

    public void configureSchema(AttributesSchema attributesSchema) {
        this.configureCategoryDisambiguationRule(attributesSchema);
    }

    private void configureCategoryDisambiguationRule(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy<Category> categorySchema = attributesSchema.attribute(Category.CATEGORY_ATTRIBUTE);
        categorySchema.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class, actionConfiguration -> {
            actionConfiguration.params(this.library);
            actionConfiguration.params(this.regularPlatform);
        });
    }

    public <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, Category category) {
        dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, category));
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal(variant.getAttributes().getAttribute(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE), "enforced-platform");
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<Category>,
    ReusableAction {
        final Category library;
        final Category platform;

        @Inject
        ComponentCategoryDisambiguationRule(Category library, Category regularPlatform) {
            this.library = library;
            this.platform = regularPlatform;
        }

        @Override
        public void execute(MultipleCandidatesDetails<Category> details) {
            Category consumerValue = details.getConsumerValue();
            if (consumerValue == null) {
                Set<Category> candidateValues = details.getCandidateValues();
                if (candidateValues.contains(this.library)) {
                    details.closestMatch(this.library);
                } else if (candidateValues.contains(this.platform)) {
                    details.closestMatch(this.platform);
                }
            }
        }
    }
}

