/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCachesProvider;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.ivyservice.DefaultArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ReadOnlyArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.WritableArtifactCacheLockingManager;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.IncubationLogger;

public class DefaultArtifactCaches
implements ArtifactCachesProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultArtifactCaches.class);
    private final DefaultArtifactCacheMetadata writableCacheMetadata;
    private final DefaultArtifactCacheMetadata readOnlyCacheMetadata;
    private final LateInitWritableArtifactCacheLockingManager writableArtifactCacheLockingManager;
    private final ReadOnlyArtifactCacheLockingManager readOnlyArtifactCacheLockingManager;

    public DefaultArtifactCaches(CacheScopeMapping cacheScopeMapping, CacheRepository cacheRepository, Factory<WritableArtifactCacheLockingParameters> writableArtifactCacheLockingParametersFactory, DocumentationRegistry documentationRegistry) {
        this.writableCacheMetadata = new DefaultArtifactCacheMetadata(cacheScopeMapping);
        this.writableArtifactCacheLockingManager = new LateInitWritableArtifactCacheLockingManager(() -> {
            WritableArtifactCacheLockingParameters params = (WritableArtifactCacheLockingParameters)writableArtifactCacheLockingParametersFactory.create();
            return new WritableArtifactCacheLockingManager(cacheRepository, this.writableCacheMetadata, params.getFileAccessTimeJournal(), params.getUsedGradleVersions());
        });
        String roCache = System.getenv("GRADLE_RO_DEP_CACHE");
        if (StringUtils.isNotEmpty(roCache)) {
            IncubationLogger.incubatingFeatureUsed("Shared read-only dependency cache");
            File baseDir = DefaultArtifactCaches.validateReadOnlyCache(documentationRegistry, new File(roCache).getAbsoluteFile());
            if (baseDir != null) {
                this.readOnlyCacheMetadata = new DefaultArtifactCacheMetadata(cacheScopeMapping, baseDir);
                this.readOnlyArtifactCacheLockingManager = new ReadOnlyArtifactCacheLockingManager(cacheRepository, this.readOnlyCacheMetadata);
            } else {
                this.readOnlyCacheMetadata = null;
                this.readOnlyArtifactCacheLockingManager = null;
            }
        } else {
            this.readOnlyCacheMetadata = null;
            this.readOnlyArtifactCacheLockingManager = null;
        }
    }

    @Nullable
    private static File validateReadOnlyCache(DocumentationRegistry documentationRegistry, File cacheDir) {
        if (!cacheDir.exists()) {
            LOGGER.warn("The read-only dependency cache is disabled because of a configuration problem:");
            LOGGER.warn("The GRADLE_RO_DEP_CACHE environment variable was set to " + cacheDir + " which doesn't exist!");
            return null;
        }
        File root = CacheLayout.ROOT.getPath(cacheDir);
        if (!root.exists()) {
            String docLink = documentationRegistry.getDocumentationFor("dependency_resolution", "sub:shared-readonly-cache");
            LOGGER.warn("The read-only dependency cache is disabled because of a configuration problem:");
            LOGGER.warn("Read-only cache is configured but the directory layout isn't expected. You must have a pre-populated " + CacheLayout.ROOT.getKey() + " directory at " + root + " . Please follow the instructions at " + docLink);
            return null;
        }
        return cacheDir;
    }

    @Override
    public ArtifactCacheMetadata getWritableCacheMetadata() {
        return this.writableCacheMetadata;
    }

    @Override
    public Optional<ArtifactCacheMetadata> getReadOnlyCacheMetadata() {
        return Optional.ofNullable(this.readOnlyCacheMetadata);
    }

    @Override
    public ArtifactCacheLockingManager getWritableCacheLockingManager() {
        return this.writableArtifactCacheLockingManager;
    }

    @Override
    public Optional<ArtifactCacheLockingManager> getReadOnlyCacheLockingManager() {
        return Optional.ofNullable(this.readOnlyArtifactCacheLockingManager);
    }

    @Override
    public List<File> getGlobalCacheRoots() {
        return this.readOnlyCacheMetadata == null ? ImmutableList.of() : this.readOnlyCacheMetadata.getGlobalCacheRoots();
    }

    @Override
    public void close() {
        this.writableArtifactCacheLockingManager.close();
        if (this.readOnlyArtifactCacheLockingManager != null) {
            this.readOnlyArtifactCacheLockingManager.close();
        }
    }

    private static class LateInitWritableArtifactCacheLockingManager
    implements ArtifactCacheLockingManager,
    Closeable {
        private final Factory<WritableArtifactCacheLockingManager> factory;
        private volatile WritableArtifactCacheLockingManager delegate;

        private LateInitWritableArtifactCacheLockingManager(Factory<WritableArtifactCacheLockingManager> factory) {
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WritableArtifactCacheLockingManager getDelegate() {
            if (this.delegate == null) {
                Factory<WritableArtifactCacheLockingManager> factory = this.factory;
                synchronized (factory) {
                    if (this.delegate == null) {
                        this.delegate = this.factory.create();
                    }
                }
            }
            return this.delegate;
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        @Override
        public <T> T withFileLock(Factory<? extends T> action) {
            return this.getDelegate().withFileLock(action);
        }

        @Override
        public void withFileLock(Runnable action) {
            this.getDelegate().withFileLock(action);
        }

        @Override
        public <T> T useCache(Factory<? extends T> action) {
            return this.getDelegate().useCache(action);
        }

        @Override
        public void useCache(Runnable action) {
            this.getDelegate().useCache(action);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return this.getDelegate().createCache(cacheName, keySerializer, valueSerializer);
        }
    }

    public static interface WritableArtifactCacheLockingParameters {
        public FileAccessTimeJournal getFileAccessTimeJournal();

        public UsedGradleVersions getUsedGradleVersions();
    }
}

