/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyArtifactSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultArtifactSelectionDetails
implements ArtifactSelectionDetailsInternal {
    private final DefaultDependencySubstitution owner;
    private final List<DependencyArtifactSelector> requestedSelectors;
    private List<DependencyArtifactSelector> targetSelectors;

    public DefaultArtifactSelectionDetails(DefaultDependencySubstitution defaultDependencySubstitution, List<IvyArtifactName> requested) {
        this.owner = defaultDependencySubstitution;
        this.requestedSelectors = requested.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(requested.stream().map(e -> new DefaultDependencyArtifactSelector(e.getType(), e.getExtension(), e.getClassifier())).collect(Collectors.toList()));
    }

    @Override
    public boolean hasSelectors() {
        return !this.requestedSelectors.isEmpty();
    }

    @Override
    public List<DependencyArtifactSelector> getRequestedSelectors() {
        return this.requestedSelectors;
    }

    @Override
    public void withoutArtifactSelectors() {
        this.targetSelectors = Lists.newArrayList();
        this.markUpdated();
    }

    private void markUpdated() {
        this.owner.addRuleDescriptor(ComponentSelectionReasons.SELECTED_BY_RULE);
    }

    @Override
    public void selectArtifact(String type, @Nullable String extension, @Nullable String classifier) {
        this.selectArtifact(new DefaultDependencyArtifactSelector(type, extension, classifier));
    }

    @Override
    public void selectArtifact(DependencyArtifactSelector selector) {
        if (this.targetSelectors == null) {
            this.targetSelectors = Lists.newArrayList();
            this.markUpdated();
        }
        this.targetSelectors.add(selector);
    }

    @Override
    public boolean isUpdated() {
        return this.targetSelectors != null;
    }

    @Override
    public List<DependencyArtifactSelector> getTargetSelectors() {
        return this.targetSelectors == null ? Collections.emptyList() : ImmutableList.copyOf(this.targetSelectors);
    }
}

