/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.List;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CompositeVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class UnionVersionSelector
implements CompositeVersionSelector {
    private final List<VersionSelector> selectors;

    public static UnionVersionSelector of(List<String> selectors, VersionSelectorScheme scheme) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String selector : selectors) {
            builder.add(scheme.parseSelector(selector));
        }
        return new UnionVersionSelector((List<VersionSelector>)((Object)builder.build()));
    }

    public UnionVersionSelector(List<VersionSelector> selectors) {
        this.selectors = selectors;
    }

    @Override
    public boolean isDynamic() {
        for (VersionSelector selector : this.selectors) {
            if (!selector.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresMetadata() {
        for (VersionSelector selector : this.selectors) {
            if (!selector.requiresMetadata()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesUniqueVersion() {
        for (VersionSelector selector : this.selectors) {
            if (selector.matchesUniqueVersion()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(String candidate) {
        for (VersionSelector selector : this.selectors) {
            if (!selector.accept(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(Version candidate) {
        for (VersionSelector selector : this.selectors) {
            if (!selector.accept(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(ComponentMetadata candidate) {
        for (VersionSelector selector : this.selectors) {
            if (!selector.accept(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canShortCircuitWhenVersionAlreadyPreselected() {
        for (VersionSelector selector : this.selectors) {
            if (selector.canShortCircuitWhenVersionAlreadyPreselected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getSelector() {
        throw new UnsupportedOperationException("Union selectors should only be used internally and don't provide a public string representation");
    }

    @Override
    public List<VersionSelector> getSelectors() {
        return this.selectors;
    }
}

