/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.VerificationEntry;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifierBuilder;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;

class PgpKeyGrouper {
    private static final Splitter GROUP_SPLITTER = Splitter.on(".");
    private static final String GROUP_SUFFIX = "($|([.].*))";
    private static final Joiner GROUP_JOINER = Joiner.on("[.]");
    private final DependencyVerifierBuilder verificationsBuilder;
    private final Set<VerificationEntry> entriesToBeWritten;

    PgpKeyGrouper(DependencyVerifierBuilder dependencyVerifierBuilder, Set<VerificationEntry> entriesToBeWritten) {
        this.verificationsBuilder = dependencyVerifierBuilder;
        this.entriesToBeWritten = entriesToBeWritten;
    }

    public void performPgpKeyGrouping() {
        Multimap<String, PgpEntry> keysToEntries = this.groupEntriesByPgpKey();
        keysToEntries.asMap().entrySet().forEach(e -> {
            Collection pgpKeys = (Collection)e.getValue();
            if (pgpKeys.size() > 1) {
                List<ModuleComponentIdentifier> moduleComponentIds = pgpKeys.stream().map(VerificationEntry::getId).map(ModuleComponentArtifactIdentifier::getComponentIdentifier).distinct().collect(Collectors.toList());
                if (moduleComponentIds.size() == 1) {
                    this.groupByModuleComponentId((Map.Entry<String, Collection<PgpEntry>>)e, moduleComponentIds);
                } else {
                    List<ModuleIdentifier> moduleIds = moduleComponentIds.stream().map(ModuleComponentIdentifier::getModuleIdentifier).distinct().collect(Collectors.toList());
                    if (moduleIds.size() == 1) {
                        this.groupByModuleId((Map.Entry<String, Collection<PgpEntry>>)e, moduleIds);
                    } else {
                        List<String> groups = moduleIds.stream().map(ModuleIdentifier::getGroup).distinct().collect(Collectors.toList());
                        if (groups.size() == 1) {
                            this.groupByGroupOnly((Map.Entry<String, Collection<PgpEntry>>)e, groups);
                        } else {
                            this.groupUsingRegex((Map.Entry<String, Collection<PgpEntry>>)e, groups);
                            this.processRemainingGroups((Map.Entry<String, Collection<PgpEntry>>)e, groups);
                        }
                    }
                }
            }
        });
    }

    private void processRemainingGroups(Map.Entry<String, Collection<PgpEntry>> e, List<String> groups) {
        String keyId = e.getKey();
        List remainingUntouched = e.getValue().stream().filter(p -> p.doesNotDeclareKeyGlobally(keyId)).collect(Collectors.toList());
        for (String group : groups) {
            long count = remainingUntouched.stream().filter(p -> p.getGroup().equals(group)).count();
            if (count <= 1L) continue;
            this.verificationsBuilder.addTrustedKey(keyId, group, null, null, null, false);
            remainingUntouched.stream().filter(p -> p.getGroup().equals(group)).forEach(p -> p.keyDeclaredGlobally(keyId));
        }
    }

    private void groupUsingRegex(Map.Entry<String, Collection<PgpEntry>> e, List<String> groups) {
        String keyID = e.getKey();
        List<List<String>> commonPrefixes = PgpKeyGrouper.tryComputeCommonPrefixes(groups);
        for (List<String> prefix : commonPrefixes) {
            String groupRegex = "^" + GROUP_JOINER.join(prefix) + GROUP_SUFFIX;
            this.verificationsBuilder.addTrustedKey(e.getKey(), groupRegex, null, null, null, true);
            for (PgpEntry pgpEntry : e.getValue()) {
                if (!pgpEntry.getGroup().matches(groupRegex)) continue;
                pgpEntry.keyDeclaredGlobally(keyID);
            }
        }
    }

    static List<List<String>> tryComputeCommonPrefixes(List<String> groups) {
        List splitGroups = groups.stream().map(GROUP_SPLITTER::splitToList).sorted(Comparator.comparing(List::size)).collect(Collectors.toList());
        List shortest = (List)splitGroups.get(0);
        if (shortest.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> commonPrefixes = Lists.newArrayList();
        ArrayList remainder = Lists.newArrayList(splitGroups);
        while (!remainder.isEmpty()) {
            ArrayList previous = Lists.newArrayList(remainder);
            shortest = (List)remainder.get(0);
            int prefixLen = 2;
            List<String> prefix = shortest.subList(0, prefixLen);
            List<String> commonPrefix = null;
            List<List<String>> candidatesWithSamePrefix = Lists.newArrayList(remainder);
            while ((candidatesWithSamePrefix = PgpKeyGrouper.samePrefix(prefixLen, prefix, candidatesWithSamePrefix)).size() > 1) {
                remainder.removeAll(candidatesWithSamePrefix);
                commonPrefix = prefix;
                if (++prefixLen > shortest.size()) break;
                prefix = shortest.subList(0, prefixLen);
            }
            if (commonPrefix != null) {
                commonPrefixes.add(commonPrefix);
            }
            if (!remainder.equals(previous)) continue;
            remainder.remove(0);
        }
        return commonPrefixes;
    }

    private static List<List<String>> samePrefix(int prefixLen, List<String> prefix, List<List<String>> candidates) {
        return candidates.stream().filter(groups -> groups.subList(0, prefixLen).equals(prefix)).collect(Collectors.toList());
    }

    private void markKeyDeclaredGlobally(Map.Entry<String, Collection<PgpEntry>> e) {
        String keyID = e.getKey();
        for (PgpEntry pgpEntry : e.getValue()) {
            pgpEntry.keyDeclaredGlobally(keyID);
        }
    }

    private void groupByGroupOnly(Map.Entry<String, Collection<PgpEntry>> e, List<String> groups) {
        String group = groups.get(0);
        this.verificationsBuilder.addTrustedKey(e.getKey(), group, null, null, null, false);
        this.markKeyDeclaredGlobally(e);
    }

    private void groupByModuleId(Map.Entry<String, Collection<PgpEntry>> e, List<ModuleIdentifier> moduleIds) {
        ModuleIdentifier mi = moduleIds.get(0);
        this.verificationsBuilder.addTrustedKey(e.getKey(), mi.getGroup(), mi.getName(), null, null, false);
        this.markKeyDeclaredGlobally(e);
    }

    private void groupByModuleComponentId(Map.Entry<String, Collection<PgpEntry>> e, List<ModuleComponentIdentifier> moduleComponentIds) {
        ModuleComponentIdentifier mci = moduleComponentIds.get(0);
        this.verificationsBuilder.addTrustedKey(e.getKey(), mci.getGroup(), mci.getModule(), mci.getVersion(), null, false);
        this.markKeyDeclaredGlobally(e);
    }

    private Multimap<String, PgpEntry> groupEntriesByPgpKey() {
        HashMultimap<String, PgpEntry> keysToEntries = HashMultimap.create();
        this.entriesToBeWritten.stream().filter(PgpEntry.class::isInstance).map(PgpEntry.class::cast).filter(e -> !e.getTrustedKeys().isEmpty()).forEach(e -> {
            for (String trustedKey : e.getTrustedKeys()) {
                keysToEntries.put(trustedKey, (PgpEntry)e);
            }
        });
        return keysToEntries;
    }
}

