/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.StringDeduplicatingDecoder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class ModuleMetadataStore {
    private static final Joiner PATH_JOINER = Joiner.on("/");
    private final PathKeyFileStore metaDataStore;
    private final ModuleMetadataSerializer moduleMetadataSerializer;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Interner<String> stringInterner;

    public ModuleMetadataStore(PathKeyFileStore metaDataStore, ModuleMetadataSerializer moduleMetadataSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, Interner<String> stringInterner) {
        this.metaDataStore = metaDataStore;
        this.moduleMetadataSerializer = moduleMetadataSerializer;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.stringInterner = stringInterner;
    }

    public MutableModuleComponentResolveMetadata getModuleDescriptor(ModuleComponentAtRepositoryKey component) {
        String[] filePath = this.getFilePath(component);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            MutableModuleComponentResolveMetadata mutableModuleComponentResolveMetadata;
            StringDeduplicatingDecoder decoder = new StringDeduplicatingDecoder(new KryoBackedDecoder(new FileInputStream(resource.getFile())), this.stringInterner);
            try {
                mutableModuleComponentResolveMetadata = this.moduleMetadataSerializer.read(decoder, this.moduleIdentifierFactory, Maps.newHashMap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        decoder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load module metadata from " + resource.getDisplayName(), e);
                }
            }
            decoder.close();
            return mutableModuleComponentResolveMetadata;
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentAtRepositoryKey component, ModuleComponentResolveMetadata metadata) {
        Object[] filePath = this.getFilePath(component);
        return this.metaDataStore.add(PATH_JOINER.join(filePath), moduleDescriptorFile -> {
            try (KryoBackedEncoder encoder = new KryoBackedEncoder(new FileOutputStream((File)moduleDescriptorFile));){
                this.moduleMetadataSerializer.write(encoder, metadata, Maps.newHashMap());
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        });
    }

    private String[] getFilePath(ModuleComponentAtRepositoryKey componentId) {
        ModuleComponentIdentifier moduleComponentIdentifier = componentId.getComponentId();
        return new String[]{moduleComponentIdentifier.getGroup(), moduleComponentIdentifier.getModule(), moduleComponentIdentifier.getVersion(), componentId.getRepositoryId(), "descriptor.bin"};
    }
}

