/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.IvyPatternMatcherExcludeRuleSpec;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.PatternMatcher;

final class DefaultIvyPatternMatcherExcludeRuleSpec
implements IvyPatternMatcherExcludeRuleSpec {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName ivyArtifactName;
    private final PatternMatcher matcher;
    private final boolean isArtifactExclude;
    private final int hashCode;

    public static ExcludeSpec of(ModuleIdentifier moduleId, IvyArtifactName artifact, String matcher) {
        return new DefaultIvyPatternMatcherExcludeRuleSpec(moduleId, artifact, matcher);
    }

    private DefaultIvyPatternMatcherExcludeRuleSpec(ModuleIdentifier moduleId, IvyArtifactName artifact, String matcher) {
        this.moduleId = moduleId;
        this.ivyArtifactName = artifact;
        this.matcher = PatternMatchers.getInstance().getMatcher(matcher);
        this.isArtifactExclude = this.ivyArtifactName != null;
        this.hashCode = Objects.hashCode(moduleId, this.ivyArtifactName, matcher, this.isArtifactExclude);
    }

    public String toString() {
        return "{ \"exclude-rule\" : { \"moduleId\": \"" + this.moduleId + "\", \"artifact\" : \"" + this.ivyArtifactName + "\", \"matcher\": \"" + this.matcher.getName() + "\"} }";
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        if (this.isArtifactExclude) {
            return false;
        }
        return this.matches(this.moduleId.getGroup(), module.getGroup()) && this.matches(this.moduleId.getName(), module.getName());
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        if (!this.isArtifactExclude) {
            return false;
        }
        return this.matches(this.moduleId.getGroup(), module.getGroup()) && this.matches(this.moduleId.getName(), module.getName()) && this.matches(this.ivyArtifactName.getName(), artifact.getName()) && this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) && this.matches(this.ivyArtifactName.getType(), artifact.getType());
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return this.isArtifactExclude;
    }

    private boolean matches(String expression, String input) {
        return this.matcher.getMatcher(expression).matches(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIvyPatternMatcherExcludeRuleSpec that = (DefaultIvyPatternMatcherExcludeRuleSpec)o;
        return this.hashCode == that.hashCode && this.isArtifactExclude == that.isArtifactExclude && Objects.equal(this.moduleId, that.moduleId) && Objects.equal(this.ivyArtifactName, that.ivyArtifactName) && Objects.equal(this.matcher, that.matcher);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.ivyArtifactName;
    }
}

