/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.concurrent.ExecutionException;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.internal.Describables;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;

public class CachingComponentSelectionDescriptorFactory
implements ComponentSelectionDescriptorFactory {
    private final Cache<Key, ComponentSelectionDescriptor> descriptors = CacheBuilder.newBuilder().maximumSize(10000L).build();

    @Override
    public ComponentSelectionDescriptor newDescriptor(ComponentSelectionCause cause, Describable description) {
        return this.getOrCreate(cause, description);
    }

    @Override
    public ComponentSelectionDescriptor newDescriptor(ComponentSelectionCause cause, String reason) {
        return this.getOrCreate(cause, Describables.of(reason));
    }

    @Override
    public ComponentSelectionDescriptor newDescriptor(ComponentSelectionCause cause) {
        try {
            return this.descriptors.get(new Key(cause, Describables.of(cause.getDefaultReason())), () -> new DefaultComponentSelectionDescriptor(cause));
        }
        catch (ExecutionException e) {
            return new DefaultComponentSelectionDescriptor(cause);
        }
    }

    private ComponentSelectionDescriptor getOrCreate(ComponentSelectionCause cause, Describable description) {
        try {
            return this.descriptors.get(new Key(cause, description), () -> new DefaultComponentSelectionDescriptor(cause, description));
        }
        catch (ExecutionException e) {
            return new DefaultComponentSelectionDescriptor(cause, description);
        }
    }

    private static class Key {
        private final ComponentSelectionCause cause;
        private final Describable describable;

        private Key(ComponentSelectionCause cause, Describable describable) {
            this.cause = cause;
            this.describable = describable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.cause != key.cause) {
                return false;
            }
            return this.describable.equals(key.describable);
        }

        public int hashCode() {
            int result = this.cause.hashCode();
            result = 31 * result + this.describable.hashCode();
            return result;
        }
    }
}

