/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GUtil;

public class ArchivePublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private File file;
    private AbstractArchiveTask archiveTask;

    public ArchivePublishArtifact(AbstractArchiveTask archiveTask) {
        super(archiveTask);
        this.archiveTask = archiveTask;
    }

    @Override
    public ArchivePublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String baseName = (String)this.archiveTask.getArchiveBaseName().getOrNull();
        if (baseName != null) {
            return this.withAppendix(baseName);
        }
        return (String)this.archiveTask.getArchiveAppendix().getOrNull();
    }

    private String withAppendix(String baseName) {
        String appendix = (String)this.archiveTask.getArchiveAppendix().getOrNull();
        return baseName + (GUtil.isTrue(appendix) ? "-" + appendix : "");
    }

    @Override
    public String getExtension() {
        return GUtil.getOrDefault(this.extension, () -> (String)this.archiveTask.getArchiveExtension().getOrNull());
    }

    @Override
    public String getType() {
        return GUtil.getOrDefault(this.type, () -> (String)this.archiveTask.getArchiveExtension().getOrNull());
    }

    @Override
    public String getClassifier() {
        return GUtil.getOrDefault(this.classifier, () -> (String)this.archiveTask.getArchiveClassifier().getOrNull());
    }

    @Override
    public File getFile() {
        return GUtil.getOrDefault(this.file, () -> this.archiveTask.getArchiveFile().get().getAsFile());
    }

    @Override
    public Date getDate() {
        return GUtil.getOrDefault(this.date, () -> new Date(this.archiveTask.getArchiveFile().get().getAsFile().lastModified()));
    }

    public AbstractArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public boolean shouldBePublished() {
        return this.archiveTask.isEnabled();
    }
}

