/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DefaultMavenImmutableAttributesFactory
implements MavenImmutableAttributesFactory {
    private final ImmutableAttributesFactory delegate;
    private final NamedObjectInstantiator objectInstantiator;
    private final Map<ComponentTypeEntry, ImmutableAttributes> concatCache = Maps.newConcurrentMap();

    public DefaultMavenImmutableAttributesFactory(ImmutableAttributesFactory delegate, NamedObjectInstantiator objectInstantiator) {
        this.delegate = delegate;
        this.objectInstantiator = objectInstantiator;
    }

    @Override
    public AttributeContainerInternal mutable() {
        return this.delegate.mutable();
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal parent) {
        return this.delegate.mutable(parent);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.delegate.of(key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        return this.delegate.concat(node, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        return this.delegate.concat(node, key, value);
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) {
        return this.delegate.concat(attributes1, attributes2);
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        return this.delegate.safeConcat(attributes1, attributes2);
    }

    @Override
    public ImmutableAttributes libraryWithUsage(ImmutableAttributes original, String usage) {
        ComponentTypeEntry entry = new ComponentTypeEntry(original, "library", usage);
        ImmutableAttributes result = this.concatCache.get(entry);
        if (result == null) {
            result = this.concat(original, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result = this.concat(result, (Attribute<T>)FORMAT_ATTRIBUTE, new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result = this.concat(result, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot("library", this.objectInstantiator));
            this.concatCache.put(entry, result);
        }
        return result;
    }

    @Override
    public ImmutableAttributes platformWithUsage(ImmutableAttributes original, String usage, boolean enforced) {
        String componentType = enforced ? "enforced-platform" : "platform";
        ComponentTypeEntry entry = new ComponentTypeEntry(original, componentType, usage);
        ImmutableAttributes result = this.concatCache.get(entry);
        if (result == null) {
            result = this.concat(original, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result = this.concat(result, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot(componentType, this.objectInstantiator));
            this.concatCache.put(entry, result);
        }
        return result;
    }

    private static class ComponentTypeEntry {
        private final ImmutableAttributes source;
        private final String componentType;
        private final String usage;
        private final int hashCode;

        private ComponentTypeEntry(ImmutableAttributes source, String componentType, String usage) {
            this.source = source;
            this.componentType = componentType;
            this.usage = usage;
            this.hashCode = Objects.hashCode(source, componentType, usage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentTypeEntry that = (ComponentTypeEntry)o;
            return this.hashCode == that.hashCode && Objects.equal(this.source, that.source) && Objects.equal(this.componentType, that.componentType) && Objects.equal(this.usage, that.usage);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

