/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultExternalResourceCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.authentication.Authentication;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.local.FileResourceListener;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.ResourceConnectorRepositoryTransport;
import org.gradle.internal.resource.transport.file.FileTransport;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.util.BuildCommencedTimeProvider;

public class RepositoryTransportFactory {
    private final List<ResourceConnectorFactory> registeredProtocols = Lists.newArrayList();
    private final TemporaryFileProvider temporaryFileProvider;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildCommencedTimeProvider timeProvider;
    private final ArtifactCacheLockingManager artifactCacheLockingManager;
    private final BuildOperationExecutor buildOperationExecutor;
    private final StartParameterResolutionOverride startParameterResolutionOverride;
    private final ProducerGuard<ExternalResourceName> producerGuard;
    private final FileResourceRepository fileRepository;
    private final ChecksumService checksumService;
    private final FileResourceListener listener;

    public RepositoryTransportFactory(Collection<ResourceConnectorFactory> resourceConnectorFactory, ProgressLoggerFactory progressLoggerFactory, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager, BuildOperationExecutor buildOperationExecutor, StartParameterResolutionOverride startParameterResolutionOverride, ProducerGuard<ExternalResourceName> producerGuard, FileResourceRepository fileRepository, ChecksumService checksumService, FileResourceListener listener) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.artifactCacheLockingManager = artifactCacheLockingManager;
        this.buildOperationExecutor = buildOperationExecutor;
        this.startParameterResolutionOverride = startParameterResolutionOverride;
        this.producerGuard = producerGuard;
        this.fileRepository = fileRepository;
        this.checksumService = checksumService;
        this.listener = listener;
        this.registeredProtocols.addAll(resourceConnectorFactory);
    }

    public Set<String> getRegisteredProtocols() {
        LinkedHashSet<String> validSchemes = Sets.newLinkedHashSet();
        for (ResourceConnectorFactory registeredProtocol : this.registeredProtocols) {
            validSchemes.addAll(registeredProtocol.getSupportedProtocols());
        }
        return validSchemes;
    }

    public RepositoryTransport createFileTransport(String name) {
        return new FileTransport(name, this.fileRepository, this.cachedExternalResourceIndex, this.temporaryFileProvider, this.timeProvider, this.artifactCacheLockingManager, this.producerGuard, this.checksumService, this.listener);
    }

    public RepositoryTransport createTransport(String scheme, String name, Collection<Authentication> authentications, HttpRedirectVerifier redirectVerifier) {
        return this.createTransport(Collections.singleton(scheme), name, authentications, redirectVerifier);
    }

    public RepositoryTransport createTransport(Set<String> schemes, String name, Collection<Authentication> authentications, HttpRedirectVerifier redirectVerifier) {
        this.validateSchemes(schemes);
        ResourceConnectorFactory connectorFactory = this.findConnectorFactory(schemes);
        this.validateConnectorFactoryCredentials(schemes, connectorFactory, authentications);
        if (schemes.equals(Collections.singleton("file"))) {
            return this.createFileTransport(name);
        }
        DefaultResourceConnectorSpecification connectionDetails = new DefaultResourceConnectorSpecification(authentications, redirectVerifier);
        ExternalResourceConnector resourceConnector = connectorFactory.createResourceConnector(connectionDetails);
        resourceConnector = this.startParameterResolutionOverride.overrideExternalResourceConnector(resourceConnector);
        ExternalResourceCachePolicy cachePolicy = new DefaultExternalResourceCachePolicy();
        cachePolicy = this.startParameterResolutionOverride.overrideExternalResourceCachePolicy(cachePolicy);
        return new ResourceConnectorRepositoryTransport(name, this.progressLoggerFactory, this.temporaryFileProvider, this.cachedExternalResourceIndex, this.timeProvider, this.artifactCacheLockingManager, resourceConnector, this.buildOperationExecutor, cachePolicy, this.producerGuard, this.fileRepository, this.checksumService);
    }

    private void validateSchemes(Set<String> schemes) {
        Set<String> validSchemes = this.getRegisteredProtocols();
        for (String scheme : schemes) {
            if (validSchemes.contains(scheme)) continue;
            throw new InvalidUserDataException(String.format("Not a supported repository protocol '%s': valid protocols are %s", scheme, validSchemes));
        }
    }

    private void validateConnectorFactoryCredentials(Set<String> schemes, ResourceConnectorFactory factory, Collection<Authentication> authentications) {
        HashSet<Class<? extends Authentication>> configuredAuthenticationTypes = Sets.newHashSet();
        for (Authentication authentication : authentications) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            boolean isAuthenticationSupported = false;
            Credentials credentials = authenticationInternal.getCredentials();
            boolean needCredentials = authenticationInternal.requiresCredentials();
            for (Class<? extends Authentication> authenticationType : factory.getSupportedAuthentication()) {
                if (!authenticationType.isAssignableFrom(authentication.getClass())) continue;
                isAuthenticationSupported = true;
                break;
            }
            if (!isAuthenticationSupported) {
                throw new InvalidUserDataException(String.format("Authentication scheme %s is not supported by protocol '%s'", authentication, schemes.iterator().next()));
            }
            if (credentials != null) {
                if (!((AuthenticationInternal)authentication).supports(credentials)) {
                    throw new InvalidUserDataException(String.format("Credentials type of '%s' is not supported by authentication scheme %s", credentials.getClass().getSimpleName(), authentication));
                }
            } else if (needCredentials) {
                throw new InvalidUserDataException("You cannot configure authentication schemes for this repository type if no credentials are provided.");
            }
            if (configuredAuthenticationTypes.add(authenticationInternal.getType())) continue;
            throw new InvalidUserDataException(String.format("You cannot configure multiple authentication schemes of the same type.  The duplicate one is %s.", authentication));
        }
    }

    private ResourceConnectorFactory findConnectorFactory(Set<String> schemes) {
        for (ResourceConnectorFactory protocolRegistration : this.registeredProtocols) {
            if (!protocolRegistration.getSupportedProtocols().containsAll(schemes)) continue;
            return protocolRegistration;
        }
        throw new InvalidUserDataException("You cannot mix different URL schemes for a single repository. Please declare separate repositories.");
    }

    private static class DefaultResourceConnectorSpecification
    implements ResourceConnectorSpecification {
        private final Collection<Authentication> authentications;
        private final HttpRedirectVerifier redirectVerifier;

        private DefaultResourceConnectorSpecification(Collection<Authentication> authentications, HttpRedirectVerifier redirectVerifier) {
            this.authentications = authentications;
            this.redirectVerifier = redirectVerifier;
        }

        @Override
        public <T> T getCredentials(Class<T> type) {
            if (this.authentications == null || this.authentications.size() < 1) {
                return null;
            }
            Credentials credentials = ((AuthenticationInternal)this.authentications.iterator().next()).getCredentials();
            if (credentials == null) {
                return null;
            }
            if (type.isAssignableFrom(credentials.getClass())) {
                return type.cast(credentials);
            }
            throw new IllegalArgumentException(String.format("Credentials must be an instance of '%s'.", type.getCanonicalName()));
        }

        @Override
        public Collection<Authentication> getAuthentications() {
            return this.authentications;
        }

        @Override
        public HttpRedirectVerifier getRedirectVerifier() {
            return this.redirectVerifier;
        }
    }
}

