/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class IgnoringResourceFilter
implements ResourceFilter {
    private final Set<String> ignores;
    private final ImmutableSet<PathMatcher> ignoreMatchers;

    public IgnoringResourceFilter(ImmutableSet<String> ignores) {
        this.ignores = ignores;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String ignore : ignores) {
            PathMatcher matcher = PatternMatcherFactory.compile(true, ignore);
            builder.add(matcher);
        }
        this.ignoreMatchers = builder.build();
    }

    private boolean shouldBeIgnored(String[] relativePath) {
        for (PathMatcher ignoreSpec : this.ignoreMatchers) {
            if (!ignoreSpec.matches(relativePath, 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        for (String ignore : this.ignores) {
            hasher.putString(ignore);
        }
    }

    @Override
    public boolean shouldBeIgnored(Supplier<String[]> relativePathFactory) {
        if (this.ignoreMatchers.isEmpty()) {
            return false;
        }
        return this.shouldBeIgnored(relativePathFactory.get());
    }
}

