/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionBackedFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileCollection;
import org.gradle.api.internal.file.SubtractingFileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.GUtil;

public abstract class AbstractFileCollection
implements FileCollectionInternal {
    protected final Factory<PatternSet> patternSetFactory;

    protected AbstractFileCollection(Factory<PatternSet> patternSetFactory) {
        this.patternSetFactory = patternSetFactory;
    }

    public AbstractFileCollection() {
        this.patternSetFactory = PatternSets.getNonCachingPatternSetFactory();
    }

    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final TreeFormatter describeContents(TreeFormatter formatter) {
        formatter.node("collection type: ").appendType(this.getClass()).append(" (id: ").append(String.valueOf(System.identityHashCode(this))).append(")");
        formatter.startChildren();
        this.appendContents(formatter);
        formatter.endChildren();
        return formatter;
    }

    protected void appendContents(TreeFormatter formatter) {
    }

    @Override
    public final TaskDependency getBuildDependencies() {
        this.assertCanCarryBuildDependencies();
        return new AbstractTaskDependency(){

            public String toString() {
                return "Dependencies of " + AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(AbstractFileCollection.this);
            }
        };
    }

    protected void assertCanCarryBuildDependencies() {
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        if (original == this) {
            return supplier.get();
        }
        return this;
    }

    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visitContents(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File content : contents) {
                    files.add(content);
                }
            }

            private void addTreeContents(FileTreeInternal fileTree) {
                files.addAll(fileTree.getFiles());
            }

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.addTreeContents(fileTree);
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                this.addTreeContents(fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.addTreeContents(fileTree);
            }
        });
        return files;
    }

    @Override
    public File getSingleFile() throws IllegalStateException {
        Iterator<File> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        File singleFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains more than one file.", this.getDisplayName()));
        }
        return singleFile;
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @Override
    public String getAsPath() {
        return GUtil.asPath(this);
    }

    @Override
    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    @Override
    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, (FileCollectionInternal)collection);
    }

    @Override
    public Provider<Set<FileSystemLocation>> getElements() {
        return new ElementsProvider(this);
    }

    @Override
    public FileCollection minus(FileCollection collection) {
        return new SubtractingFileCollection(this, collection);
    }

    @Override
    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryTree> getAsFileTrees() {
        final ArrayList<DirectoryTree> fileTrees = new ArrayList<DirectoryTree>();
        this.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File file : contents) {
                    if (!file.isFile()) continue;
                    fileTrees.add(new FileBackedDirectoryFileTree(file));
                }
            }

            @Override
            public void visitFileTree(final File root, final PatternSet patterns, FileTreeInternal fileTree) {
                if (root.isFile()) {
                    fileTrees.add(new FileBackedDirectoryFileTree(root));
                } else if (root.isDirectory()) {
                    fileTrees.add(new DirectoryTree(){

                        @Override
                        public File getDir() {
                            return root;
                        }

                        @Override
                        public PatternSet getPatterns() {
                            return patterns;
                        }
                    });
                }
            }

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                if (AbstractFileCollection.visitAll(sourceTree)) {
                    fileTrees.add(sourceTree.getMirror());
                }
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.visitGenericFileTree(fileTree, sourceTree);
            }
        });
        return fileTrees;
    }

    protected static boolean visitAll(FileSystemMirroringFileTree tree) {
        final MutableBoolean hasContent = new MutableBoolean();
        tree.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return new FileCollectionBackedFileTree(this.patternSetFactory, this);
    }

    @Override
    public FileCollection filter(Closure filterClosure) {
        return this.filter(Specs.convertClosureToSpec(filterClosure));
    }

    @Override
    public FileCollectionInternal filter(Spec<? super File> filterSpec) {
        return new FilteredFileCollection(this, filterSpec);
    }

    @Override
    public final void visitStructure(FileCollectionStructureVisitor visitor) {
        if (visitor.startVisit(OTHER, this)) {
            this.visitContents(visitor);
        }
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        visitor.visitCollection(OTHER, this);
    }

    private static class ElementsProvider
    extends AbstractProviderWithValue<Set<FileSystemLocation>> {
        private final AbstractFileCollection collection;

        public ElementsProvider(AbstractFileCollection collection) {
            this.collection = collection;
        }

        @Override
        public Class<Set<FileSystemLocation>> getType() {
            return (Class)Cast.uncheckedCast(Set.class);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return new ValueSupplier.ValueProducer(){

                @Override
                public boolean isProducesDifferentValueOverTime() {
                    return false;
                }

                @Override
                public void visitProducerTasks(Action<? super Task> visitor) {
                    for (Task task : collection.getBuildDependencies().getDependencies(null)) {
                        visitor.execute(task);
                    }
                }
            };
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<Set<FileSystemLocation>> calculateExecutionTimeValue() {
            ValueSupplier.ExecutionTimeValue<Set<FileSystemLocation>> value = ValueSupplier.ExecutionTimeValue.fixedValue((Set)this.get());
            if (this.contentsAreBuiltByTask()) {
                return value.withChangingContent();
            }
            return value;
        }

        private boolean contentsAreBuiltByTask() {
            return !this.collection.getBuildDependencies().getDependencies(null).isEmpty();
        }

        @Override
        protected ValueSupplier.Value<Set<FileSystemLocation>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            Set<File> files = this.collection.getFiles();
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(files.size());
            for (File file : files) {
                builder.add(new DefaultFileSystemLocation(file));
            }
            return ValueSupplier.Value.of(builder.build());
        }
    }
}

