/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedList;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.FluentIterable;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.metaobject.BeanDynamicObject;

public class AntFileCollectionMatchingTaskBuilder
implements AntBuilderAware {
    private final Iterable<DirectoryTree> fileTrees;

    public AntFileCollectionMatchingTaskBuilder(Iterable<DirectoryTree> fileTrees) {
        this.fileTrees = fileTrees;
    }

    @Override
    public Object addToAntBuilder(final Object node, String childNodeName) {
        final BeanDynamicObject dynamicObject = new BeanDynamicObject(node);
        final LinkedList<DirectoryTree> existing = Lists.newLinkedList(FluentIterable.from(this.fileTrees).filter(new Predicate<DirectoryTree>(){

            @Override
            public boolean apply(DirectoryTree input) {
                return input.getDir().exists();
            }
        }));
        for (DirectoryTree fileTree : existing) {
            dynamicObject.invokeMethod(childNodeName, Collections.singletonMap("location", fileTree.getDir()));
        }
        dynamicObject.invokeMethod("or", new Closure<Void>((Object)this){

            public Object doCall(Object ignore) {
                for (final DirectoryTree fileTree : existing) {
                    dynamicObject.invokeMethod("and", new Closure<Void>((Object)this){

                        public Object doCall(Object ignore) {
                            dynamicObject.invokeMethod("gradleBaseDirSelector", Collections.singletonMap("baseDir", fileTree.getDir()));
                            fileTree.getPatterns().addToAntBuilder(node, null);
                            return null;
                        }
                    });
                }
                return null;
            }
        });
        return node;
    }
}

