/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.DefaultCompositeFileTree;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderResolutionStrategy;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class DefaultFileCollectionFactory
implements FileCollectionFactory {
    public static final String DEFAULT_COLLECTION_DISPLAY_NAME = "file collection";
    public static final String DEFAULT_TREE_DISPLAY_NAME = "file tree";
    private static final EmptyFileCollection EMPTY_COLLECTION = new EmptyFileCollection("file collection");
    private final PathToFileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Factory<PatternSet> patternSetFactory;
    private final PropertyHost propertyHost;
    private final FileSystem fileSystem;

    public DefaultFileCollectionFactory(PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory, Factory<PatternSet> patternSetFactory, PropertyHost propertyHost, FileSystem fileSystem) {
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSetFactory = patternSetFactory;
        this.propertyHost = propertyHost;
        this.fileSystem = fileSystem;
    }

    @Override
    public FileCollectionFactory withResolver(PathToFileResolver fileResolver) {
        if (fileResolver == this.fileResolver) {
            return this;
        }
        return new DefaultFileCollectionFactory(fileResolver, this.taskDependencyFactory, this.directoryFileTreeFactory, this.patternSetFactory, this.propertyHost, this.fileSystem);
    }

    @Override
    public ConfigurableFileCollection configurableFiles() {
        return new DefaultConfigurableFileCollection(null, this.fileResolver, this.taskDependencyFactory, this.patternSetFactory, this.propertyHost);
    }

    @Override
    public ConfigurableFileCollection configurableFiles(String displayName) {
        return new DefaultConfigurableFileCollection(displayName, this.fileResolver, this.taskDependencyFactory, this.patternSetFactory, this.propertyHost);
    }

    @Override
    public ConfigurableFileTree fileTree() {
        return new DefaultConfigurableFileTree(this.fileResolver, this.patternSetFactory, this.taskDependencyFactory, this.directoryFileTreeFactory);
    }

    @Override
    public FileTreeInternal treeOf(List<? extends FileTreeInternal> fileTrees) {
        if (fileTrees.isEmpty()) {
            return new EmptyFileTree();
        }
        if (fileTrees.size() == 1) {
            return fileTrees.get(0);
        }
        return new DefaultCompositeFileTree(this.patternSetFactory, ImmutableList.copyOf(fileTrees));
    }

    @Override
    public FileTreeInternal treeOf(MinimalFileTree tree) {
        return new FileTreeAdapter(tree, this.patternSetFactory);
    }

    @Override
    public FileCollectionInternal create(final TaskDependency builtBy, MinimalFileSet contents) {
        return new FileCollectionAdapter(contents, this.patternSetFactory){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                context.add(builtBy);
            }
        };
    }

    @Override
    public FileCollectionInternal create(MinimalFileSet contents) {
        return new FileCollectionAdapter(contents, this.patternSetFactory);
    }

    @Override
    public FileCollectionInternal resolving(String displayName, Object sources) {
        return this.resolving(displayName, ProviderResolutionStrategy.REQUIRE_PRESENT, sources);
    }

    @Override
    public FileCollectionInternal resolvingLeniently(String displayName, Object sources) {
        return this.resolving(displayName, ProviderResolutionStrategy.ALLOW_ABSENT, sources);
    }

    private FileCollectionInternal resolving(String displayName, ProviderResolutionStrategy providerResolutionStrategy, Object sources) {
        if (this.isEmptyArray(sources)) {
            return this.empty(displayName);
        }
        return new ResolvingFileCollection(displayName, this.fileResolver, this.patternSetFactory, providerResolutionStrategy, sources);
    }

    @Override
    public FileCollectionInternal resolving(Object sources) {
        return this.resolving(ProviderResolutionStrategy.REQUIRE_PRESENT, sources);
    }

    @Override
    public FileCollectionInternal resolvingLeniently(Object sources) {
        return this.resolving(ProviderResolutionStrategy.ALLOW_ABSENT, sources);
    }

    private FileCollectionInternal resolving(ProviderResolutionStrategy providerResolutionStrategy, Object sources) {
        if (sources instanceof FileCollectionInternal) {
            return (FileCollectionInternal)sources;
        }
        if (this.isEmptyArray(sources)) {
            return this.empty();
        }
        return this.resolving(DEFAULT_COLLECTION_DISPLAY_NAME, providerResolutionStrategy, sources);
    }

    @Override
    public FileCollectionInternal empty(String displayName) {
        return new EmptyFileCollection(displayName);
    }

    @Override
    public FileCollectionInternal empty() {
        return EMPTY_COLLECTION;
    }

    @Override
    public FileCollectionInternal fixed(File ... files) {
        if (files.length == 0) {
            return this.empty();
        }
        return this.fixed(DEFAULT_COLLECTION_DISPLAY_NAME, files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, File ... files) {
        if (files.length == 0) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, this.patternSetFactory, ImmutableSet.copyOf(files));
    }

    @Override
    public FileCollectionInternal fixed(Collection<File> files) {
        if (files.isEmpty()) {
            return this.empty();
        }
        return this.fixed(DEFAULT_COLLECTION_DISPLAY_NAME, files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, Collection<File> files) {
        if (files.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, this.patternSetFactory, ImmutableSet.copyOf(files));
    }

    @Override
    public FileTreeInternal generated(Factory<File> tmpDir, String fileName, Action<File> fileGenerationListener, Action<OutputStream> contentWriter) {
        return new FileTreeAdapter(new GeneratedSingletonFileTree(tmpDir, fileName, fileGenerationListener, contentWriter, this.fileSystem), this.patternSetFactory);
    }

    private boolean isEmptyArray(Object sources) {
        return sources.getClass().isArray() && Array.getLength(sources) == 0;
    }

    private static class ResolvingFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private final PathToFileResolver resolver;
        private final Object source;
        private final ProviderResolutionStrategy providerResolutionStrategy;

        public ResolvingFileCollection(String displayName, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, ProviderResolutionStrategy providerResolutionStrategy, Object source) {
            super(patternSetFactory);
            this.displayName = displayName;
            this.resolver = resolver;
            this.source = source;
            this.providerResolutionStrategy = providerResolutionStrategy;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            UnpackingVisitor nested = new UnpackingVisitor(visitor, this.resolver, this.patternSetFactory, this.providerResolutionStrategy, true);
            nested.add(this.source);
        }

        @Override
        protected void appendContents(TreeFormatter formatter) {
            formatter.node("source");
            formatter.startChildren();
            this.appendItem(formatter, this.source);
            formatter.endChildren();
        }

        private void appendItem(TreeFormatter formatter, Object item) {
            if (item instanceof FileCollectionInternal) {
                ((FileCollectionInternal)item).describeContents(formatter);
            } else if (item instanceof ArrayList) {
                for (Object child : (List)item) {
                    this.appendItem(formatter, child);
                }
            } else {
                formatter.node(item + " (class: " + item.getClass().getName() + ")");
            }
        }
    }

    private static final class FixedFileCollection
    extends AbstractOpaqueFileCollection {
        private final String displayName;
        private final ImmutableSet<File> files;

        public FixedFileCollection(String displayName, Factory<PatternSet> patternSetFactory, ImmutableSet<File> files) {
            super(patternSetFactory);
            this.displayName = displayName;
            this.files = files;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        protected Set<File> getIntrinsicFiles() {
            return this.files;
        }
    }

    private static final class EmptyFileTree
    extends AbstractFileTree {
        private EmptyFileTree() {
        }

        @Override
        public String getDisplayName() {
            return DefaultFileCollectionFactory.DEFAULT_TREE_DISPLAY_NAME;
        }

        @Override
        public Set<File> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FileTree matching(Closure filterConfigClosure) {
            return this;
        }

        @Override
        public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
            return this;
        }

        @Override
        public FileTreeInternal matching(PatternFilterable patterns) {
            return this;
        }

        @Override
        public FileTree visit(FileVisitor visitor) {
            return this;
        }

        @Override
        public void visitContentsAsFileTrees(Consumer<FileTreeInternal> visitor) {
        }

        @Override
        protected void visitContents(FileCollectionStructureVisitor visitor) {
        }
    }

    private static final class EmptyFileCollection
    extends AbstractFileCollection {
        private final String displayName;

        public EmptyFileCollection(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Set<File> getFiles() {
            return ImmutableSet.of();
        }

        @Override
        protected void visitContents(FileCollectionStructureVisitor visitor) {
        }

        @Override
        public FileTreeInternal getAsFileTree() {
            return new EmptyFileTree();
        }
    }
}

