/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.util.CollectionUtils;

public class FilteredFileCollection
extends AbstractFileCollection {
    private final FileCollectionInternal collection;
    private final Spec<? super File> filterSpec;

    public FilteredFileCollection(AbstractFileCollection collection, Spec<? super File> filterSpec) {
        super(collection.patternSetFactory);
        this.collection = collection;
        this.filterSpec = filterSpec;
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        AbstractFileCollection newCollection = (AbstractFileCollection)this.collection.replace(original, supplier);
        if (newCollection == this.collection) {
            return this;
        }
        return new FilteredFileCollection(newCollection, this.filterSpec);
    }

    public FileCollectionInternal getCollection() {
        return this.collection;
    }

    public Spec<? super File> getFilterSpec() {
        return this.filterSpec;
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.collection.visitDependencies(context);
    }

    @Override
    public Set<File> getFiles() {
        return CollectionUtils.filter(this.collection, new LinkedHashSet(), this.filterSpec);
    }

    @Override
    public boolean contains(File file) {
        return this.collection.contains(file) && this.filterSpec.isSatisfiedBy(file);
    }

    @Override
    public Iterator<File> iterator() {
        return Iterators.filter(this.collection.iterator(), this.filterSpec::isSatisfiedBy);
    }
}

