/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.file.ImmutablePatternSet;
import org.gradle.api.tasks.util.PatternSet;

public final class ImmutableDirectoryTree
implements DirectoryTree {
    private final File dir;
    private final ImmutablePatternSet patternSet;

    public static ImmutableDirectoryTree of(DirectoryTree source) {
        if (source instanceof ImmutableDirectoryTree) {
            return (ImmutableDirectoryTree)source;
        }
        return ImmutableDirectoryTree.of(source.getDir(), source.getPatterns());
    }

    public static ImmutableDirectoryTree of(File dir2, PatternSet patternSet) {
        return new ImmutableDirectoryTree(dir2, patternSet);
    }

    private ImmutableDirectoryTree(File dir2, PatternSet patternSet) {
        this.dir = dir2;
        this.patternSet = ImmutablePatternSet.of(patternSet);
    }

    @Override
    public File getDir() {
        return this.dir;
    }

    @Override
    public ImmutablePatternSet getPatterns() {
        return this.patternSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDirectoryTree that = (ImmutableDirectoryTree)o;
        if (this.dir != null ? !this.dir.equals(that.dir) : that.dir != null) {
            return false;
        }
        return !(this.patternSet == null ? that.patternSet != null : !this.patternSet.equals(that.patternSet));
    }

    public int hashCode() {
        int result = this.dir != null ? this.dir.hashCode() : 0;
        result = 31 * result + (this.patternSet != null ? this.patternSet.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "dir: " + this.dir.getPath();
    }
}

