/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.CompressedReadableResource;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;

public class MaybeCompressedFileResource
implements ReadableResourceInternal {
    private final ReadableResourceInternal resource;

    public MaybeCompressedFileResource(ReadableResourceInternal resource) {
        if (resource instanceof CompressedReadableResource) {
            this.resource = resource;
        } else {
            String ext = FilenameUtils.getExtension(resource.getURI().toString());
            this.resource = Compression.BZIP2.getSupportedExtensions().contains(ext) ? new Bzip2Archiver(resource) : (Compression.GZIP.getSupportedExtensions().contains(ext) ? new GzipArchiver(resource) : resource);
        }
    }

    @Override
    public InputStream read() throws MissingResourceException {
        return this.resource.read();
    }

    public ReadableResource getResource() {
        return this.resource;
    }

    @Override
    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    @Override
    public URI getURI() {
        return this.resource.getURI();
    }

    @Override
    public String getBaseName() {
        return this.resource.getBaseName();
    }

    @Override
    public File getBackingFile() {
        return this.resource.getBackingFile();
    }
}

