/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;

class JdkZipEntry
implements ZipEntry {
    private final java.util.zip.ZipEntry entry;
    private final Supplier<InputStream> inputStreamSupplier;
    private final Runnable closeAction;

    public JdkZipEntry(java.util.zip.ZipEntry entry, Supplier<InputStream> inputStreamSupplier, @Nullable Runnable closeAction) {
        this.entry = entry;
        this.inputStreamSupplier = inputStreamSupplier;
        this.closeAction = closeAction;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public byte[] getContent() throws IOException {
        return this.withInputStream(new ZipEntry.InputStreamAction<byte[]>(){

            @Override
            public byte[] run(InputStream inputStream) throws IOException {
                int size = JdkZipEntry.this.size();
                if (size >= 0) {
                    byte[] content = new byte[size];
                    ByteStreams.readFully(inputStream, content);
                    return content;
                }
                return ByteStreams.toByteArray(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withInputStream(ZipEntry.InputStreamAction<T> action) throws IOException {
        InputStream is = this.inputStreamSupplier.get();
        try {
            T t = action.run(is);
            return t;
        }
        finally {
            if (this.closeAction != null) {
                this.closeAction.run();
            } else {
                is.close();
            }
        }
    }

    @Override
    public int size() {
        return (int)this.entry.getSize();
    }
}

