/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.temp;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.temp.TempFiles;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;

public class DefaultTemporaryFileProvider
implements TemporaryFileProvider,
Serializable {
    private final Factory<File> baseDirFactory;

    public DefaultTemporaryFileProvider(Factory<File> fileFactory) {
        this.baseDirFactory = fileFactory;
    }

    @Override
    public File newTemporaryFile(String ... path) {
        return FileUtils.canonicalize(new File(this.baseDirFactory.create(), CollectionUtils.join("/", path)));
    }

    @Override
    public File createTemporaryFile(String prefix, @Nullable String suffix, String ... path) {
        File dir2 = this.newTemporaryFile(path);
        GFileUtils.mkdirs(dir2);
        try {
            return TempFiles.createTempFile(prefix, suffix, dir2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public File createTemporaryDirectory(String prefix, @Nullable String suffix, String ... path) {
        File dir2 = this.newTemporaryFile(path);
        GFileUtils.mkdirs(dir2);
        try {
            File tmpDir = TempFiles.createTempFile(prefix, suffix, dir2);
            if (!tmpDir.delete()) {
                throw new UncheckedIOException("Failed to delete file: " + tmpDir);
            }
            if (!tmpDir.mkdir()) {
                throw new UncheckedIOException("Failed to make directory: " + tmpDir);
            }
            return tmpDir;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

