/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ChangingValue;
import org.gradle.api.internal.provider.ChangingValueHandler;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultArtifactPublicationSet {
    private final PublishArtifactSet artifactContainer;
    private DefaultArtifactProvider defaultArtifactProvider;

    public DefaultArtifactPublicationSet(PublishArtifactSet artifactContainer) {
        this.artifactContainer = artifactContainer;
    }

    public void addCandidate(PublishArtifact artifact) {
        if (this.defaultArtifactProvider == null) {
            this.defaultArtifactProvider = new DefaultArtifactProvider();
            this.artifactContainer.addAllLater(this.defaultArtifactProvider);
        }
        this.defaultArtifactProvider.addArtifact(artifact);
    }

    private static class DefaultArtifactProvider
    extends AbstractMinimalProvider<Set<PublishArtifact>>
    implements CollectionProviderInternal<PublishArtifact, Set<PublishArtifact>>,
    ChangingValue<Set<PublishArtifact>> {
        private Set<PublishArtifact> defaultArtifacts;
        private Set<PublishArtifact> artifacts;
        private PublishArtifact currentDefault;
        private final ChangingValueHandler<Set<PublishArtifact>> changingValue = new ChangingValueHandler();

        private DefaultArtifactProvider() {
        }

        void addArtifact(PublishArtifact artifact) {
            if (this.artifacts == null) {
                this.artifacts = Sets.newLinkedHashSet();
            }
            if (this.artifacts.add(artifact) && this.defaultArtifacts != null) {
                LinkedHashSet<PublishArtifact> previousArtifacts = Sets.newLinkedHashSet(this.defaultArtifacts);
                this.defaultArtifacts = null;
                this.changingValue.handle(previousArtifacts);
            }
        }

        @Override
        public Class<? extends PublishArtifact> getElementType() {
            return PublishArtifact.class;
        }

        @Override
        public int size() {
            return this.artifacts.size();
        }

        @Override
        @Nullable
        public Class<Set<PublishArtifact>> getType() {
            return null;
        }

        @Override
        protected ValueSupplier.Value<Set<PublishArtifact>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            if (this.defaultArtifacts == null) {
                this.defaultArtifacts = Sets.newLinkedHashSet();
                this.currentDefault = null;
                if (this.artifacts != null) {
                    for (PublishArtifact artifact : this.artifacts) {
                        String thisType = artifact.getType();
                        if (this.currentDefault == null) {
                            this.defaultArtifacts.add(artifact);
                            this.currentDefault = artifact;
                            continue;
                        }
                        String currentType = this.currentDefault.getType();
                        if (thisType.equals("ear")) {
                            this.replaceCurrent(artifact);
                            continue;
                        }
                        if (thisType.equals("war")) {
                            if (!currentType.equals("jar")) continue;
                            this.replaceCurrent(artifact);
                            continue;
                        }
                        if (thisType.equals("jar")) continue;
                        this.defaultArtifacts.add(artifact);
                    }
                }
            }
            return ValueSupplier.Value.of(this.defaultArtifacts);
        }

        void replaceCurrent(PublishArtifact artifact) {
            this.defaultArtifacts.remove(this.currentDefault);
            this.defaultArtifacts.add(artifact);
            this.currentDefault = artifact;
        }

        @Override
        public void onValueChange(Action<Set<PublishArtifact>> action) {
            this.changingValue.onValueChange(action);
        }
    }
}

