/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.Closeable;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.internal.project.DefaultAntBuilder;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.ant.AntLoggingAdapterFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;

public class DefaultAntBuilderFactory
implements Factory<AntBuilder>,
Closeable {
    private final Project project;
    private final AntLoggingAdapterFactory loggingAdapterFactory;
    private final CompositeStoppable stoppable = new CompositeStoppable();

    public DefaultAntBuilderFactory(Project project, AntLoggingAdapterFactory loggingAdapterFactory) {
        this.project = project;
        this.loggingAdapterFactory = loggingAdapterFactory;
    }

    @Override
    public DefaultAntBuilder create() {
        AntLoggingAdapter loggingAdapter = (AntLoggingAdapter)this.loggingAdapterFactory.create();
        DefaultAntBuilder antBuilder = new DefaultAntBuilder(this.project, loggingAdapter);
        antBuilder.getProject().setBaseDir(this.project.getProjectDir());
        antBuilder.getProject().removeBuildListener(antBuilder.getProject().getBuildListeners().get(0));
        antBuilder.getProject().addBuildListener(loggingAdapter);
        this.stoppable.add((Object)antBuilder);
        return antBuilder;
    }

    @Override
    public void close() {
        this.stoppable.stop();
    }
}

