/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import groovy.util.BuilderSupport;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;

public class AntBuilderDelegate
extends BuilderSupport {
    private final Object originalBuilder;
    private final DynamicObject builder;
    private final ClassLoader antlibClassLoader;

    public AntBuilderDelegate(Object builder, ClassLoader antlibClassLoader) {
        this.originalBuilder = builder;
        this.builder = DynamicObjectUtil.asDynamicObject(builder);
        this.antlibClassLoader = antlibClassLoader;
    }

    public AntBuilderDelegate getAnt() {
        return this;
    }

    private void taskdef(Map<String, String> args) {
        Set<String> argNames = args.keySet();
        if (argNames.equals(ImmutableSet.of("name", "classname"))) {
            try {
                String name = args.get("name");
                String className = args.get("classname");
                this.addTaskDefinition(name, className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        } else if (argNames.equals(Collections.singleton("resource"))) {
            InputStream instr = this.antlibClassLoader.getResourceAsStream(args.get("resource"));
            try {
                Node xml = new XmlParser().parse(instr);
                for (Object taskdefObject : (NodeList)xml.get("taskdef")) {
                    Node taskdef = (Node)taskdefObject;
                    String name = (String)taskdef.get("@name");
                    String className = (String)taskdef.get("@classname");
                    this.addTaskDefinition(name, className);
                }
            }
            catch (Exception ex) {
                throw UncheckedException.throwAsUncheckedException(ex);
            }
            finally {
                IoActions.closeQuietly(instr);
            }
        } else {
            throw new RuntimeException("Unsupported parameters for taskdef(): " + args);
        }
    }

    private void addTaskDefinition(String name, String className) throws ClassNotFoundException {
        DynamicObject project = DynamicObjectUtil.asDynamicObject(this.builder.getProperty("project"));
        project.invokeMethod("addTaskDefinition", name, this.antlibClassLoader.loadClass(className));
    }

    public Object propertyMissing(String name) {
        return this.builder.getProperty(name);
    }

    protected Object createNode(Object name) {
        return this.builder.invokeMethod("createNode", name);
    }

    protected Object createNode(Object name, Map attributes) {
        if (!name.equals("taskdef")) {
            return this.builder.invokeMethod("createNode", name, attributes);
        }
        this.taskdef((Map)Cast.uncheckedCast(attributes));
        return null;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        return this.builder.invokeMethod("createNode", name, attributes, value);
    }

    protected Object createNode(Object name, Object value) {
        return this.builder.invokeMethod("createNode", name, value);
    }

    protected void setParent(Object parent, Object child) {
        this.builder.invokeMethod("setParent", parent, child);
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (parent == null && node == null) {
            return;
        }
        this.builder.invokeMethod("nodeCompleted", parent, node);
    }

    protected Object postNodeCompletion(Object parent, Object node) {
        return this.builder.invokeMethod("postNodeCompletion", parent, node);
    }

    public Object getBuilder() {
        return this.originalBuilder;
    }
}

