/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

class OrElseProvider<T>
extends AbstractMinimalProvider<T> {
    private final ProviderInternal<T> left;
    private final ProviderInternal<? extends T> right;

    public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.left.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        ValueSupplier.ExecutionTimeValue<T> leftValue = this.left.calculateExecutionTimeValue();
        return leftValue.isMissing() ? this.right.getProducer() : new OrElseValueProducer();
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.left.calculatePresence(consumer) || this.right.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<T> leftValue = this.left.calculateExecutionTimeValue();
        if (!leftValue.isMissing()) {
            return leftValue;
        }
        return super.calculateExecutionTimeValue();
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> leftValue = this.left.calculateValue(consumer);
        if (!leftValue.isMissing()) {
            return leftValue;
        }
        ValueSupplier.Value<T> rightValue = this.right.calculateValue(consumer);
        if (!rightValue.isMissing()) {
            return rightValue;
        }
        return leftValue.addPathsFrom(rightValue);
    }

    private class OrElseValueProducer
    implements ValueSupplier.ValueProducer {
        final ValueSupplier.ValueProducer leftProducer;
        final ValueSupplier.ValueProducer rightProducer;

        private OrElseValueProducer() {
            this.leftProducer = OrElseProvider.this.left.getProducer();
            this.rightProducer = OrElseProvider.this.right.getProducer();
        }

        @Override
        public boolean isKnown() {
            return this.leftProducer.isKnown() || this.rightProducer.isKnown();
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return this.leftProducer.isProducesDifferentValueOverTime() || this.rightProducer.isProducesDifferentValueOverTime();
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            ArrayList<Task> leftTasks = this.producerTasksOf(this.leftProducer);
            ArrayList<Task> rightTasks = this.producerTasksOf(this.rightProducer);
            if (leftTasks.isEmpty() && rightTasks.isEmpty()) {
                return;
            }
            ArrayList<Task> producerTasks = OrElseProvider.this.left.isPresent() ? leftTasks : rightTasks;
            producerTasks.forEach(visitor::execute);
        }

        private ArrayList<Task> producerTasksOf(ValueSupplier.ValueProducer producer) {
            ArrayList<Task> tasks = new ArrayList<Task>();
            producer.visitProducerTasks(tasks::add);
            return tasks;
        }
    }
}

