/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarCreator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeShadedJarFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarFactory.class);
    private final GeneratedGradleJarCache cache;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final BuildOperationExecutor executor;

    public RuntimeShadedJarFactory(GeneratedGradleJarCache cache2, ProgressLoggerFactory progressLoggerFactory, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, BuildOperationExecutor executor) {
        this.cache = cache2;
        this.progressLoggerFactory = progressLoggerFactory;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.executor = executor;
    }

    public File get(final RuntimeShadedJarType type, Collection<? extends File> classpath) {
        File jarFile = this.cache.get(type.getIdentifier(), (File file) -> this.executor.run(new RunnableBuildOperation((File)file, classpath){
            final /* synthetic */ File val$file;
            final /* synthetic */ Collection val$classpath;
            {
                this.val$file = file;
                this.val$classpath = collection;
            }

            @Override
            public void run(BuildOperationContext context) {
                RuntimeShadedJarCreator creator = new RuntimeShadedJarCreator(RuntimeShadedJarFactory.this.progressLoggerFactory, new ImplementationDependencyRelocator(type), RuntimeShadedJarFactory.this.classpathWalker, RuntimeShadedJarFactory.this.classpathBuilder);
                creator.create(this.val$file, this.val$classpath);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Generate " + this.val$file).progressDisplayName("Generating " + this.val$file.getName());
            }
        }));
        LOGGER.debug("Using Gradle runtime shaded JAR file: {}", (Object)jarFile);
        return jarFile;
    }
}

