/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

public class DefaultTaskDependency
extends AbstractTaskDependency {
    private final ImmutableSet<Object> immutableValues;
    private Set<Object> mutableValues;
    private final TaskResolver resolver;

    public DefaultTaskDependency() {
        this(null);
    }

    public DefaultTaskDependency(@Nullable TaskResolver resolver) {
        this(resolver, ImmutableSet.of());
    }

    public DefaultTaskDependency(@Nullable TaskResolver resolver, ImmutableSet<Object> immutableValues) {
        this.resolver = resolver;
        this.immutableValues = immutableValues;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        Set<Object> mutableValues = this.getMutableValues();
        if (mutableValues.isEmpty() && this.immutableValues.isEmpty()) {
            return;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>(mutableValues.size() + this.immutableValues.size());
        queue.addAll(this.immutableValues);
        queue.addAll(mutableValues);
        while (!queue.isEmpty()) {
            Object dependency = queue.removeFirst();
            if (dependency instanceof Buildable) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof Task) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof TaskDependency) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof ProviderInternal) {
                ProviderInternal provider = (ProviderInternal)dependency;
                ValueSupplier.ValueProducer producer = provider.getProducer();
                if (producer.isKnown()) {
                    producer.visitProducerTasks(context);
                    continue;
                }
                queue.addFirst(provider.get());
                continue;
            }
            if (dependency instanceof TaskDependencyContainer) {
                ((TaskDependencyContainer)dependency).visitDependencies(context);
                continue;
            }
            if (dependency instanceof Closure) {
                Closure closure = (Closure)dependency;
                Object closureResult = closure.call((Object)context.getTask());
                if (closureResult == null) continue;
                queue.addFirst(closureResult);
                continue;
            }
            if (dependency instanceof List) {
                List list = (List)dependency;
                if (list instanceof RandomAccess) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        queue.addFirst(list.get(i));
                    }
                    continue;
                }
                ListIterator iterator = list.listIterator(list.size());
                while (iterator.hasPrevious()) {
                    Object item = iterator.previous();
                    queue.addFirst(item);
                }
                continue;
            }
            if (dependency instanceof Iterable && !(dependency instanceof Path)) {
                Iterable iterable = (Iterable)Cast.uncheckedNonnullCast(dependency);
                DefaultTaskDependency.addAllFirst(queue, Iterables.toArray(iterable, Object.class));
                continue;
            }
            if (dependency instanceof Map) {
                Map map = (Map)Cast.uncheckedNonnullCast(dependency);
                DefaultTaskDependency.addAllFirst(queue, map.values().toArray());
                continue;
            }
            if (dependency instanceof Object[]) {
                Object[] array = (Object[])dependency;
                DefaultTaskDependency.addAllFirst(queue, array);
                continue;
            }
            if (dependency instanceof Callable) {
                Callable callable = (Callable)Cast.uncheckedNonnullCast(dependency);
                Object callableResult = GUtil.uncheckedCall((Callable)Cast.uncheckedNonnullCast(callable));
                if (callableResult == null) continue;
                queue.addFirst(callableResult);
                continue;
            }
            if (this.resolver != null && dependency instanceof CharSequence) {
                context.add(this.resolver.resolveTask(dependency.toString()));
                continue;
            }
            ArrayList<String> formats = new ArrayList<String>();
            if (this.resolver != null) {
                formats.add("A String or CharSequence task name or path");
            }
            formats.add("A Task instance");
            formats.add("A TaskReference instance");
            formats.add("A Buildable instance");
            formats.add("A TaskDependency instance");
            formats.add("A Provider that represents a task output");
            formats.add("A Provider instance that returns any of these types");
            formats.add("A Closure instance that returns any of these types");
            formats.add("A Callable instance that returns any of these types");
            formats.add("An Iterable, Collection, Map or array instance that contains any of these types");
            throw new UnsupportedNotationException(dependency, String.format("Cannot convert %s to a task.", dependency), null, formats);
        }
    }

    private static void addAllFirst(Deque<Object> queue, Object[] items) {
        for (int i = items.length - 1; i >= 0; --i) {
            queue.addFirst(items[i]);
        }
    }

    public Set<Object> getMutableValues() {
        if (this.mutableValues == null) {
            this.mutableValues = new TaskDependencySet();
        }
        return this.mutableValues;
    }

    public void setValues(Iterable<?> values) {
        this.getMutableValues().clear();
        for (Object value : values) {
            this.addValue(value);
        }
    }

    public DefaultTaskDependency add(Object ... values) {
        for (Object value : values) {
            this.addValue(value);
        }
        return this;
    }

    private void addValue(Object dependency) {
        if (dependency == null) {
            throw new InvalidUserDataException("A dependency must not be empty");
        }
        this.getMutableValues().add(dependency);
    }

    private static class TaskDependencySet
    implements Set<Object> {
        private final Set<Object> delegate = Sets.newHashSet();
        private static final String REMOVE_ERROR = "Removing a task dependency from a task instance is not supported.";

        private TaskDependencySet() {
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            return this.delegate.add(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(REMOVE_ERROR);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException(REMOVE_ERROR);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException(REMOVE_ERROR);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

