/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.ModuleVisitor;
import org.gradle.language.base.internal.compile.Compiler;

public class ModuleApplicationNameWritingCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;

    public ModuleApplicationNameWritingCompiler(Compiler<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(T spec) {
        File moduleInfo;
        WorkResult result = this.delegate.execute(spec);
        String mainClass = spec.getCompileOptions().getJavaModuleMainClass();
        if (mainClass != null && (moduleInfo = new File(spec.getDestinationDir(), "module-info.class")).exists()) {
            ModuleApplicationNameWritingCompiler.addMainClass(moduleInfo, mainClass);
        }
        return result;
    }

    private static void addMainClass(File moduleInfo, String mainClass) {
        try (FileInputStream inputStream = new FileInputStream(moduleInfo);){
            ClassReader classReader = new ClassReader(inputStream);
            ClassWriter classWriter = new ClassWriter(classReader, 0);
            ModuleInfoVisitor moduleInfoVisitor = new ModuleInfoVisitor(mainClass, (ClassVisitor)classWriter);
            classReader.accept(moduleInfoVisitor, 0);
            FileOutputStream out = new FileOutputStream(moduleInfo);
            out.write(classWriter.toByteArray());
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ModuleMainClassWriter
    extends ModuleVisitor {
        private final String mainClass;

        private ModuleMainClassWriter(String mainClass, ModuleVisitor mv) {
            super(262144, mv);
            this.mainClass = mainClass;
        }

        @Override
        public void visitEnd() {
            this.mv.visitMainClass(this.mainClass.replace('.', '/'));
            super.visitEnd();
        }
    }

    private static class ModuleInfoVisitor
    extends ClassVisitor {
        private final String mainClass;

        public ModuleInfoVisitor(String mainClass, ClassVisitor cv) {
            super(262144, cv);
            this.mainClass = mainClass;
        }

        @Override
        public ModuleVisitor visitModule(String name, int access, String version) {
            return new ModuleMainClassWriter(this.mainClass, this.cv.visitModule(name, access, version));
        }
    }
}

