/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotFactory;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathSnapshotMaker
implements ClasspathSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathSnapshotMaker.class);
    private final ClasspathSnapshotFactory classpathSnapshotFactory;
    private ClasspathSnapshot classpathSnapshot;

    public ClasspathSnapshotMaker(ClasspathSnapshotFactory classpathSnapshotFactory) {
        this.classpathSnapshotFactory = classpathSnapshotFactory;
    }

    @Override
    public ClasspathSnapshot getClasspathSnapshot(Iterable<File> classpath) {
        this.maybeInitialize(classpath);
        return this.classpathSnapshot;
    }

    private void maybeInitialize(Iterable<File> classpath) {
        if (this.classpathSnapshot != null) {
            return;
        }
        Timer clock = Time.startTimer();
        this.classpathSnapshot = this.classpathSnapshotFactory.createSnapshot(classpath);
        int duplicatesCount = this.classpathSnapshot.getData().getDuplicateClasses().size();
        String duplicateClassesMessage = duplicatesCount == 0 ? "" : ". " + duplicatesCount + " duplicate classes found in classpath (see all with --debug)";
        LOG.info("Created classpath snapshot for incremental compilation in {}{}.", (Object)clock.getElapsed(), (Object)duplicateClassesMessage);
        LOG.debug("While calculating classpath snapshot {} duplicate classes were found: {}.", (Object)duplicatesCount, (Object)this.classpathSnapshot.getData().getDuplicateClasses());
    }
}

