/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import java.util.function.Function;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache {
    private final FileSystemAccess fileSystemAccess;
    private final MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData> cache;

    public DefaultClasspathEntrySnapshotCache(FileSystemAccess fileSystemAccess, PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData> persistentCache) {
        this.fileSystemAccess = fileSystemAccess;
        this.cache = new MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData>(persistentCache);
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        ClasspathEntrySnapshotData data = this.cache.getIfPresent(hash);
        return data != null ? new ClasspathEntrySnapshot(data) : null;
    }

    @Override
    public ClasspathEntrySnapshot get(File key, Function<? super File, ? extends ClasspathEntrySnapshot> factory) {
        HashCode fileContentHash = this.getFileContentHash(key);
        return new ClasspathEntrySnapshot(this.cache.get(fileContentHash, () -> ((ClasspathEntrySnapshot)factory.apply(key)).getData()));
    }

    private HashCode getFileContentHash(File key) {
        return this.fileSystemAccess.read(key.getAbsolutePath(), FileSystemLocationSnapshot::getHash);
    }

    @Override
    public ClasspathEntrySnapshot getIfPresent(File key) {
        HashCode fileContentHash = this.getFileContentHash(key);
        ClasspathEntrySnapshotData classpathEntrySnapshotData = this.cache.getIfPresent(fileContentHash);
        return classpathEntrySnapshotData == null ? null : new ClasspathEntrySnapshot(classpathEntrySnapshotData);
    }

    @Override
    public void put(File key, ClasspathEntrySnapshot value) {
        HashCode fileContentHash = this.getFileContentHash(key);
        this.cache.put(fileContentHash, value.getData());
    }
}

